/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.fluid;

import com.igteam.immersivegeology.common.fluid.IGFluid;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialChemical;
import com.igteam.immersivegeology.core.material.data.types.MaterialMetal;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class IGFluidType
extends FluidType {
    private final BlockCategoryFlags category;
    private final MaterialInterface<?> base;
    @Nullable
    private final MaterialInterface<?> overlay;
    private final IGFluid fluid;

    public IGFluidType(IGFluid fluid, MaterialInterface<?> base, @Nullable MaterialInterface<?> overlay, BlockCategoryFlags category) {
        super(base.getFluidProperties());
        this.base = base;
        this.overlay = overlay;
        this.category = category;
        this.fluid = fluid;
    }

    public Component getDescription() {
        ArrayList<String> materialList = new ArrayList<String>();
        String type = "";
        MaterialInterface<?> baseMaterial = this.base;
        MaterialInterface<?> overlayMaterial = this.overlay;
        if (baseMaterial instanceof MaterialMetal) {
            materialList.add(I18n.m_118938_((String)"material.immersivegeology.fluid_type.molten", (Object[])new Object[0]));
            type = "_molten";
        }
        if (baseMaterial instanceof MaterialChemical) {
            MaterialChemical chemical_base = (MaterialChemical)((Object)baseMaterial);
            if (chemical_base.hasComplexNamingScheme()) {
                materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
                materialList.add(I18n.m_118938_((String)("component.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
                return Component.m_237110_((String)("fluid.immersivegeology." + this.category.getName().toLowerCase() + type), (Object[])materialList.toArray());
            }
            materialList.add(I18n.m_118938_((String)("material.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
            materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
        }
        if (baseMaterial != null) {
            materialList.add(I18n.m_118938_((String)("material.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
        }
        if (overlayMaterial != null) {
            materialList.add(I18n.m_118938_((String)("material.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
        }
        if (this.category.equals(BlockCategoryFlags.SLURRY)) {
            materialList.add(I18n.m_118938_((String)"material.immersivegeology.fluid_type.clean_slurry", (Object[])new Object[0]));
        }
        if (this.category.equals(BlockCategoryFlags.CLOUDY_SLURRY)) {
            materialList.add(I18n.m_118938_((String)"material.immersivegeology.fluid_type.cloudy_slurry", (Object[])new Object[0]));
        }
        return Component.m_237110_((String)("fluid.immersivegeology." + this.category.getName().toLowerCase() + type), (Object[])materialList.toArray());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Component getDescription(FluidStack stack) {
        ArrayList<String> materialList = new ArrayList<String>();
        String type = "fluid";
        MaterialInterface<?> baseMaterial = this.base;
        MaterialInterface<?> overlayMaterial = this.overlay;
        if (baseMaterial instanceof MetalEnum) {
            type = "fluid_molten";
        }
        if (baseMaterial instanceof ChemicalEnum) {
            ChemicalEnum chemical_base = (ChemicalEnum)baseMaterial;
            if (overlayMaterial != null) {
                type = this.category.getName().toLowerCase();
                if (!chemical_base.hasComplexNamingScheme()) {
                    materialList.add(I18n.m_118938_((String)("material.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
                    materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
                    return Component.m_237110_((String)("fluid.immersivegeology." + type), (Object[])materialList.toArray());
                }
                materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
                materialList.add(I18n.m_118938_((String)("component.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
                type = this.category.equals(BlockCategoryFlags.CLOUDY_SLURRY) ? "cloudy_complex_slurry" : "complex_slurry";
                return Component.m_237110_((String)("fluid.immersivegeology." + type), (Object[])materialList.toArray());
            }
        }
        materialList.add(I18n.m_118938_((String)("material.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
        return Component.m_237110_((String)("fluid.immersivegeology." + type), (Object[])materialList.toArray());
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(this.getFluidExtendedProperties(this.category));
    }

    public IClientFluidTypeExtensions getFluidExtendedProperties(final BlockCategoryFlags flag) {
        final IGFluidType fluid = this;
        return new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return fluid.overlay != null ? fluid.overlay.getColor(flag, 0) : fluid.base.getColor(flag, 0);
            }

            public ResourceLocation getStillTexture() {
                return fluid.base.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? new ResourceLocation("immersivegeology", "block/fluid/molten_still") : new ResourceLocation("immersivegeology", "block/fluid/default_still");
            }

            public ResourceLocation getFlowingTexture() {
                return fluid.base.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? new ResourceLocation("immersivegeology", "block/fluid/molten_flow") : new ResourceLocation("immersivegeology", "block/fluid/default_flowing");
            }

            public void renderOverlay(Minecraft mc, PoseStack poseStack) {
            }
        };
    }
}

