/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalExchangerRecipe;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class IGGeothermalExchangerCategory
extends IGRecipeCategory<GeothermalExchangerRecipe> {
    private static IDrawableStatic flame_icon;
    private static IDrawableStatic ice_icon;

    public IGGeothermalExchangerCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.GEOTHERMAL_EXCHANGER, "block.immersivegeology.geothermal_exchanger");
        ResourceLocation background = new ResourceLocation("immersivegeology", "textures/gui/jei/geothermal_exchanger.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 101, 101).setTextureSize(128, 128).build();
        this.setBackground(back);
        this.setIcon(IGMultiblockProvider.GEOTHERMAL_EXCHANGER.iconStack());
        flame_icon = this.guiHelper.drawableBuilder(background, 101, 0, 11, 14).setTextureSize(128, 128).build();
        ice_icon = this.guiHelper.drawableBuilder(background, 114, 0, 13, 14).setTextureSize(128, 128).build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeothermalExchangerRecipe recipe, IFocusGroup focuses) {
        int tankSize = Math.max(2000, Math.max(recipe.fluidIn.getAmount(), recipe.fluidIn.getAmount()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 11, 23).setFluidRenderer((long)tankSize, false, 16, 55).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.fluidIn.getMatchingFluidStacks())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        if (!((FluidStack)recipe.fluidOutput.get()).isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 23).setFluidRenderer(432L, false, 16, 55).addFluidStack(((FluidStack)recipe.fluidOutput.get()).getFluid(), (long)((FluidStack)recipe.fluidOutput.get()).getAmount())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
    }

    public void draw(GeothermalExchangerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (recipe.isCooling()) {
            ice_icon.draw(guiGraphics, 43, 53);
        } else {
            flame_icon.draw(guiGraphics, 44, 53);
        }
    }
}

