/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import com.igteam.immersivegeology.common.block.multiblocks.recipe.GravitySeparatorRecipe;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class IGSeparatorCategory
extends IGRecipeCategory<GravitySeparatorRecipe> {
    public IGSeparatorCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.SEPARATOR, "block.immersivegeology.gravity_separator");
        ResourceLocation background = new ResourceLocation("immersivegeology", "textures/gui/jei/gravity_separator.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 101, 101).setTextureSize(101, 101).build();
        this.setBackground(back);
        this.setIcon(IGMultiblockProvider.GRAVITY_SEPARATOR.iconStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GravitySeparatorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 33).addItemStacks(Arrays.asList(recipe.itemIn.m_43908_()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 42).addItemStack((ItemStack)recipe.itemOutput.get());
        String chance = Math.round(recipe.getChance() * 100.0f) + "% Output Chance";
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 62).addItemStack((ItemStack)recipe.itemByproduct.get())).addTooltipCallback((a, b) -> b.add(Component.m_237113_((String)chance)));
    }

    public void draw(GravitySeparatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        float c = recipe.getChance() * 100.0f;
        int time = recipe.getTotalProcessTime();
        int timeInSeconds = time / 20;
        guiGraphics.m_280488_(this.font, timeInSeconds + " Seconds", 7, 58, -1);
        String chance = Math.round(c) + "%";
        guiGraphics.m_280488_(this.font, chance, 85, 67, -1);
    }
}

