/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGGenericBucketItem
extends BucketItem
implements IGFlagItem,
DispensibleContainerItem {
    private final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    private final BlockCategoryFlags fluid_category;
    private final ItemCategoryFlags bucket_type;

    public IGGenericBucketItem(Supplier<? extends Fluid> fluid, BlockCategoryFlags flag, ItemCategoryFlags bucket_type, MaterialInterface<?> material) {
        super(fluid, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_));
        this.materialMap.put(MaterialTexture.base, material);
        this.fluid_category = flag;
        this.bucket_type = bucket_type;
    }

    public IGGenericBucketItem(Supplier<? extends Fluid> fluid, BlockCategoryFlags flag, ItemCategoryFlags bucket_type, MaterialInterface<?> material, MaterialInterface<?> extra) {
        this(fluid, flag, bucket_type, material);
        this.materialMap.put(MaterialTexture.overlay, extra);
    }

    @Override
    public int getColor(int index) {
        if (index == 0) {
            return -1;
        }
        if (index >= this.materialMap.values().size()) {
            index = this.materialMap.values().size() - 1;
        }
        return this.materialMap.get((Object)MaterialTexture.values()[index]).getColor(ItemCategoryFlags.BUCKET, 0);
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        ArrayList<String> materialList = new ArrayList<String>();
        String type = "bucket";
        MaterialInterface<?> baseMaterial = this.getMaterial(MaterialTexture.base);
        MaterialInterface<?> overlayMaterial = this.getMaterial(MaterialTexture.overlay);
        if (this.bucket_type.equals(ItemCategoryFlags.BUCKET)) {
            type = "bucket_molten";
            materialList.add(I18n.m_118938_((String)("material.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
        }
        if (this.bucket_type.equals(ItemCategoryFlags.CLEAN_FLASK)) {
            type = "clean_flask_slurry";
            if (overlayMaterial != null) {
                if (baseMaterial instanceof ChemicalEnum) {
                    ChemicalEnum chemical_base = (ChemicalEnum)baseMaterial;
                    if (chemical_base.hasComplexNamingScheme()) {
                        materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
                        materialList.add(I18n.m_118938_((String)("component.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
                        return Component.m_237110_((String)("item.immersivegeology.complex_" + type), (Object[])materialList.toArray());
                    }
                    materialList.add(I18n.m_118938_((String)("material.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
                    materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
                } else {
                    IGLib.IG_LOGGER.warn("Clean Slurry Flask being used for non ChemicalEnum Base Material see {} {}", (Object)baseMaterial.getName(), (Object)overlayMaterial.getName());
                }
            } else {
                type = "flask";
                materialList.add(I18n.m_118938_((String)("material.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
            }
        }
        if (this.bucket_type.equals(ItemCategoryFlags.CLOUDY_FLASK)) {
            type = "cloudy_flask_slurry";
            if (overlayMaterial != null) {
                materialList.add(I18n.m_118938_((String)("material.immersivegeology." + overlayMaterial.getName()), (Object[])new Object[0]));
                materialList.add(I18n.m_118938_((String)("component.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
            } else {
                type = "flask";
                materialList.add(I18n.m_118938_((String)("material.immersivegeology." + baseMaterial.getName()), (Object[])new Object[0]));
            }
        }
        return Component.m_237110_((String)("item.immersivegeology." + type), (Object[])materialList.toArray());
    }

    public ItemCategoryFlags getFlag() {
        return ItemCategoryFlags.BUCKET;
    }

    public BlockCategoryFlags getFluidCategory() {
        return this.fluid_category;
    }

    @Override
    public ItemSubGroup getSubGroup() {
        return ItemCategoryFlags.BUCKET.getSubGroup();
    }

    @Override
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandler(stack);
    }

    public IFlagType<?> getBucketType() {
        return this.bucket_type;
    }

    public boolean emptyContents(@Nullable Player p_150716_, Level p_150717_, BlockPos p_150718_, @Nullable BlockHitResult p_150719_, @Nullable ItemStack container) {
        return super.emptyContents(p_150716_, p_150717_, p_150718_, p_150719_, container);
    }

    private static class FluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private final ItemStack stack;
        private boolean empty = false;
        private final LazyOptional<IFluidHandlerItem> lazyOpt = CapabilityUtils.constantOptional((Object)this);

        private FluidHandler(ItemStack stack) {
            this.stack = stack;
        }

        private FluidStack getFluid() {
            Fluid fluid = ((IGGenericBucketItem)this.stack.m_41720_()).getFluid();
            if (this.empty) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(fluid, 1000);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.empty ? new ItemStack((ItemLike)Items.f_42446_) : this.stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank == 0) {
                return this.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack fluid = this.getFluid();
            if (!fluid.isFluidEqual(resource) || !Objects.equals(fluid.getTag(), resource.getTag())) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.empty || this.stack.m_41613_() > 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack potion = this.getFluid();
            if (action.execute()) {
                this.empty = true;
            }
            return potion;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM) {
                return this.lazyOpt.cast();
            }
            return LazyOptional.empty();
        }
    }
}

