/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.igteam.immersivegeology.common.item.IGGenericItem;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class IGGenericDrillHead
extends IGGenericItem
implements IDrillHead {
    public DrillHeadProps perms;

    public IGGenericDrillHead(ItemCategoryFlags flag, MaterialInterface<?> material) {
        super(flag, material, new Item.Properties().m_41487_(1).m_41503_(material.drillHeadInstance().maxDamage));
        this.perms = material.drillHeadInstance();
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.size", (Object[])new Object[]{this.perms.drillSize, this.perms.drillDepth}));
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.level", (Object[])new Object[]{Utils.getHarvestLevelName((Tier)this.getMiningLevel(stack))}));
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.speed", (Object[])new Object[]{Utils.formatDouble((double)this.getMiningSpeed(stack), (String)"0.###")}));
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.damage", (Object[])new Object[]{Utils.formatDouble((double)this.getAttackDamage(stack), (String)"0.###")}));
        int maxDmg = this.getMaximumHeadDamage(stack);
        int dmg = maxDmg - this.getHeadDamage(stack);
        float quote = (float)dmg / (float)maxDmg;
        ChatFormatting var10000 = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
        String status = String.valueOf(var10000);
        String s = status + (this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack)) + "/" + this.getMaximumHeadDamage(stack);
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.info.durability", (Object[])new Object[]{s}));
    }

    public boolean m_6832_(ItemStack stack, ItemStack material) {
        return material.m_204117_(this.perms.repairMaterial);
    }

    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, Player player) {
        return false;
    }

    public void afterBlockbreak(ItemStack drill, ItemStack head, Player player) {
    }

    public Tier getMiningLevel(ItemStack head) {
        return this.perms.drillLevel;
    }

    public float getMiningSpeed(ItemStack head) {
        return this.perms.drillSpeed;
    }

    public float getAttackDamage(ItemStack head) {
        return this.perms.drillAttack;
    }

    public int getHeadDamage(ItemStack head) {
        if (head.m_41782_()) {
            CompoundTag nbt = head.m_41784_();
            return nbt.m_128425_("headDamage", 3) ? nbt.m_128451_("headDamage") : nbt.m_128451_("Damage");
        }
        return 0;
    }

    public int getMaximumHeadDamage(ItemStack head) {
        return this.perms.maxDamage;
    }

    public void damageHead(ItemStack head, int dmg) {
        IGGenericDrillHead.setHeadDamage(head, this.getHeadDamage(head) + dmg);
    }

    public static void setHeadDamage(ItemStack head, int totalDamage) {
        CompoundTag nbt = head.m_41784_();
        nbt.m_128473_("headDamage");
        nbt.m_128405_("Damage", totalDamage);
    }

    public ResourceLocation getDrillTexture(ItemStack drill, ItemStack head) {
        return this.perms.texture.get();
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getHeadDamage(stack) / (float)this.getMaximumHeadDamage(stack)));
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    public ImmutableList<BlockPos> getExtraBlocksDug(ItemStack head, Level world, Player player, HitResult rtr) {
        if (!(rtr instanceof BlockHitResult)) {
            return ImmutableList.of();
        }
        BlockHitResult brtr = (BlockHitResult)rtr;
        Direction side = brtr.m_82434_();
        int diameter = this.perms.drillSize;
        int depth = this.perms.drillDepth;
        BlockPos startPos = brtr.m_82425_();
        BlockState state = world.m_8055_(startPos);
        float maxHardness = 1.0f;
        if (!state.m_60795_()) {
            maxHardness = state.m_60625_(player, (BlockGetter)world, startPos) * 0.4f;
        }
        if (maxHardness < 0.0f) {
            maxHardness = 0.0f;
        }
        if (diameter % 2 == 0) {
            float hx = (float)brtr.m_82450_().f_82479_ - (float)brtr.m_82425_().m_123341_();
            float hy = (float)brtr.m_82450_().f_82480_ - (float)brtr.m_82425_().m_123342_();
            float hz = (float)brtr.m_82450_().f_82481_ - (float)brtr.m_82425_().m_123343_();
            if (side.m_122434_() == Direction.Axis.Y && (double)hx < 0.5 || side.m_122434_() == Direction.Axis.Z && (double)hx < 0.5) {
                startPos = startPos.m_7918_(-diameter / 2, 0, 0);
            }
            if (side.m_122434_() != Direction.Axis.Y && (double)hy < 0.5) {
                startPos = startPos.m_7918_(0, -diameter / 2, 0);
            }
            if (side.m_122434_() == Direction.Axis.Y && (double)hz < 0.5 || side.m_122434_() == Direction.Axis.X && (double)hz < 0.5) {
                startPos = startPos.m_7918_(0, 0, -diameter / 2);
            }
        } else {
            startPos = startPos.m_7918_(-(side.m_122434_() == Direction.Axis.X ? 0 : diameter / 2), -(side.m_122434_() == Direction.Axis.Y ? 0 : diameter / 2), -(side.m_122434_() == Direction.Axis.Z ? 0 : diameter / 2));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    boolean hardness;
                    BlockPos pos = startPos.m_7918_(side.m_122434_() == Direction.Axis.X ? dd : dw, side.m_122434_() == Direction.Axis.Y ? dd : dh, side.m_122434_() == Direction.Axis.Y ? dh : (side.m_122434_() == Direction.Axis.X ? dw : dd));
                    if (pos.equals((Object)brtr.m_82425_()) || (state = world.m_8055_(pos)).m_60795_()) continue;
                    Block block = state.m_60734_();
                    float h = state.m_60625_(player, (BlockGetter)world, pos);
                    boolean canHarvest = block.canHarvestBlock(world.m_8055_(pos), (BlockGetter)world, pos, player);
                    boolean drillMat = ((DrillItem)IEItems.Tools.DRILL.get()).isEffective(ItemStack.f_41583_, state);
                    boolean bl = hardness = h >= maxHardness;
                    if (!canHarvest || !drillMat || !hardness) continue;
                    b.add((Object)pos);
                }
            }
        }
        return b.build();
    }

    public static class DrillHeadProps {
        final String name;
        final TagKey<Item> repairMaterial;
        final int drillSize;
        final int drillDepth;
        final Tier drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        public final Supplier<ResourceLocation> texture;

        public DrillHeadProps(String name, TagKey<Item> repairMaterial, int drillSize, int drillDepth, Tier drillLevel, float drillSpeed, int drillAttack, int maxDamage, Supplier<ResourceLocation> texture) {
            this.name = name;
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
        }
    }
}

