/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.item.IGGenericItem;
import com.igteam.immersivegeology.core.material.data.types.MaterialNativeMetal;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGGenericOreItem
extends IGGenericItem {
    private final OreRichness oreRichness;

    public IGGenericOreItem(ItemCategoryFlags flag, MaterialInterface<?> material) {
        super(flag, material);
        this.oreRichness = flag.equals(ItemCategoryFlags.RICH_ORE) ? OreRichness.RICH : (flag.equals(ItemCategoryFlags.NORMAL_ORE) ? OreRichness.NORMAL : OreRichness.POOR);
    }

    @Override
    public int getColor(int index) {
        return super.getColor(index);
    }

    @Override
    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return super.getBurnTime(itemStack, recipeType) * (this.oreRichness.ordinal() + 1);
    }

    @Override
    @NotNull
    public Component m_7626_(ItemStack stack) {
        String grade = this.getFlag().equals(ItemCategoryFlags.NORMAL_ORE) ? "normal" : (this.getFlag().equals(ItemCategoryFlags.RICH_ORE) ? "rich" : "poor");
        MutableComponent normalName = Component.m_237115_((String)("material.immersivegeology.ore." + grade));
        if (!grade.equals("normal")) {
            normalName.m_7220_((Component)Component.m_237115_((String)"formatting.space"));
        }
        for (MaterialTexture t : MaterialTexture.values()) {
            if (!this.materialMap.containsKey((Object)t)) continue;
            MaterialInterface base = (MaterialInterface)this.materialMap.get((Object)t);
            if (List.of(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POOR_ORE, ItemCategoryFlags.NORMAL_ORE, ItemCategoryFlags.RICH_ORE, ItemCategoryFlags.DIRTY_CRUSHED_ORE).contains(this.getFlag()) && base.instance() instanceof MaterialNativeMetal) {
                normalName.m_7220_((Component)Component.m_237115_((String)"material.immersivegeology.native")).m_7220_((Component)Component.m_237115_((String)"formatting.space"));
            }
            normalName.m_7220_((Component)Component.m_237115_((String)("material.immersivegeology." + base.getName())));
        }
        return normalName;
    }

    public OreRichness getOreRichness() {
        return this.oreRichness;
    }
}

