/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.item.IGGenericItem;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;

public class IGMineralTestingItem
extends IGGenericItem
implements IGFlagItem {
    private final HashMap<ChunkPos, MineralCacheEntry> cached_test = new HashMap();

    public IGMineralTestingItem(ItemCategoryFlags flag, MaterialInterface<?> material, int durability) {
        super(flag, material, new Item.Properties().m_41503_(durability));
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    @NotNull
    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)"item.immersivegeology.prospector_pick");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player == null || !stack.m_41720_().equals(this)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos usedPos = context.m_8083_();
        ChunkPos centreChunkPos = new ChunkPos(usedPos);
        stack.m_41622_(1, (LivingEntity)player, p -> {});
        MineralCacheEntry cachedEntry = this.cached_test.get(centreChunkPos);
        if (cachedEntry != null) {
            long currentTimestamp = System.currentTimeMillis();
            if (currentTimestamp - cachedEntry.timestamp > 10000L) {
                this.cached_test.clear();
            } else {
                player.m_5661_((Component)Component.m_237113_((String)cachedEntry.message), true);
                return InteractionResult.SUCCESS;
            }
        }
        int centreChunkX = centreChunkPos.f_45578_;
        int centreChunkZ = centreChunkPos.f_45579_;
        int minBuildHeight = level.m_141937_();
        int maxBuildHeight = level.m_151558_();
        int sectionMin = level.m_151564_(minBuildHeight);
        int sectionMax = level.m_151564_(maxBuildHeight);
        HashSet oreSet = new HashSet();
        TagKey<Block> allOresTag = BlockCategoryFlags.ORE_BLOCK.getCategoryTag();
        block0: for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                LevelChunk chunk = level.m_6325_(centreChunkX + dx, centreChunkZ + dz);
                for (int sectionIndex = sectionMin; sectionIndex < sectionMax; ++sectionIndex) {
                    LevelChunkSection section = chunk.m_183278_(sectionIndex);
                    if (section.m_188008_() || !section.m_63002_(b -> b.m_204336_(allOresTag))) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                BlockState blockState = section.m_62982_(x, y, z);
                                if (!blockState.m_204336_(allOresTag)) continue;
                                IOreBlock ore = (IOreBlock)blockState.m_60734_();
                                oreSet.add(ore.getOreMaterial());
                                if (oreSet.size() >= 3) break block0;
                            }
                        }
                    }
                }
            }
        }
        Component message = IGMineralTestingItem.getMessage(oreSet);
        player.m_5661_(message, true);
        this.cached_test.put(centreChunkPos, new MineralCacheEntry(message.getString()));
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean isIGRepairable(ItemStack stack) {
        return true;
    }

    @NotNull
    private static Component getMessage(Set<MaterialInterface<?>> oreSet) {
        MutableComponent message;
        if (oreSet.isEmpty()) {
            message = Component.m_237115_((String)"immersivegeology.prospecting_pick.nothing");
        } else {
            ArrayList found = new ArrayList(oreSet);
            String messageKey = "immersivegeology.prospecting_pick.found";
            message = Component.m_237110_((String)messageKey, (Object[])new Object[]{switch (found.size()) {
                case 1 -> "Found Traces of " + String.valueOf(found.get(0));
                case 2 -> "Found Traces of " + String.valueOf(found.get(0)) + " and " + String.valueOf(found.get(1));
                default -> "Found Cluster of " + String.valueOf(found.get(0)) + ", " + String.valueOf(found.get(1)) + " and " + String.valueOf(found.get(2));
            }});
        }
        return message;
    }

    private static class MineralCacheEntry {
        public static final long CACHE_EXPIRY = 10000L;
        final String message;
        final long timestamp;

        public MineralCacheEntry(String message) {
            this.message = message;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

