/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import com.igteam.immersivegeology.common.block.multiblocks.skins.helpers.IIGMultiSkinHelper;
import com.igteam.immersivegeology.common.item.IGGenericItem;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGMultiblockSkinItem<T extends Enum<T> & StringRepresentable>
extends IGGenericItem {
    private final T skin;
    private final String registryName;

    public IGMultiblockSkinItem(ItemCategoryFlags flag, MaterialInterface<?> material, T skinEnum, String registryName) {
        super(flag, material, new Item.Properties().m_41487_(1).m_41497_(((IIGMultiSkinHelper)skinEnum).getRarity()));
        this.skin = skinEnum;
        this.registryName = registryName;
    }

    public Enum<?> getSkin() {
        return this.skin;
    }

    @Override
    @NotNull
    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)("item.immersivegeology." + this.category.getName()), (Object[])new Object[]{Component.m_237115_((String)("block.immersivegeology." + ((IIGMultiSkinHelper)this.skin).multiblockName()))});
    }

    @Override
    public int getColor(int index) {
        ChatFormatting col = ((IIGMultiSkinHelper)this.skin).getColor();
        if (col.m_126665_() == null) {
            return -1;
        }
        return index == 1 ? col.m_126665_() : -1;
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        MutableComponent skin_name = Component.m_237115_((String)("skin.immersivegeology." + ((IIGMultiSkinHelper)this.skin).multiblockName() + "." + ((StringRepresentable)this.skin).m_7912_())).m_130940_(((IIGMultiSkinHelper)this.skin).getColor());
        MutableComponent skin_type = Component.m_237115_((String)("skin.immersivegeology.credit." + ((IIGMultiSkinHelper)this.skin).getType().name().toLowerCase())).m_130940_(((IIGMultiSkinHelper)this.skin).getType().getColor());
        MutableComponent credit = Component.m_237115_((String)("skin.immersivegeology." + ((IIGMultiSkinHelper)this.skin).getCredit())).m_130940_(ChatFormatting.DARK_GRAY);
        MutableComponent description = Component.m_237110_((String)"skin.immersivegeology.description", (Object[])new Object[]{credit, skin_name, skin_type}).m_130940_(ChatFormatting.DARK_GRAY);
        pTooltipComponents.add((Component)description);
    }

    public String getRegistryName() {
        return this.registryName;
    }
}

