/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class IGLootModifier
extends LootModifier {
    public static final Codec<IGLootModifier> CODEC = RecordCodecBuilder.create(inst -> IGLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().listOf().fieldOf("items").forGetter(m -> m.item_pool)).apply((Applicative)inst, IGLootModifier::new));
    private final List<Item> item_pool;

    public IGLootModifier(LootItemCondition[] conditionsIn, List<Item> item_pool) {
        super(conditionsIn);
        this.item_pool = item_pool;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!this.item_pool.isEmpty()) {
            Item selectedItem = this.item_pool.get(context.m_230907_().m_188503_(this.item_pool.size()));
            generatedLoot.add((Object)new ItemStack((ItemLike)selectedItem));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

