/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.network;

import blusunrize.immersiveengineering.common.network.IMessage;
import com.igteam.immersivegeology.common.network.msg.MessageSCRFail;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class IGPacketHandler {
    public static final String NET_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("immersivegeology", "main")).networkProtocolVersion(() -> "1").serverAcceptedVersions("1"::equals).clientAcceptedVersions("1"::equals).simpleChannel();
    private final Set<Class<?>> knownPacketTypes = new HashSet();
    private int messageId = 0;
    private static final IGPacketHandler handler = new IGPacketHandler();

    public static void initialize() {
        handler.registerMessage(MessageSCRFail.class, MessageSCRFail::new);
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<FriendlyByteBuf, T> decoder) {
        this.registerMessage(packetType, decoder, Optional.empty());
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<FriendlyByteBuf, T> decoder, NetworkDirection direction) {
        this.registerMessage(packetType, decoder, Optional.of(direction));
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<FriendlyByteBuf, T> decoder, Optional<NetworkDirection> direction) {
        if (!this.knownPacketTypes.add(packetType)) {
            throw new IllegalStateException("Duplicate packet type: " + packetType.getName());
        }
        INSTANCE.registerMessage(this.messageId++, packetType, IMessage::toBytes, decoder, (t, ctx) -> {
            t.process(ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }, direction);
    }

    public static <MSG> void sendToPlayer(Player player, @Nonnull MSG message) {
        if (message != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
        }
    }

    public static <MSG> void sendToServer(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static <MSG> void sendToDimension(ResourceKey<Level> dim, MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dim), message);
    }

    public static <MSG> void sendAll(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }
}

