/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.tag;

import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialChemical;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class IGTags {
    public static LinkedHashMap<IFlagType<?>, LinkedHashMap<String, TagKey<Item>>> ITEM_TAG_HOLDER = new LinkedHashMap();
    public static LinkedHashMap<IFlagType<?>, LinkedHashMap<String, TagKey<Fluid>>> FLUID_TAG_HOLDER = new LinkedHashMap();
    public static LinkedHashMap<ItemCategoryFlags, TagKey<Item>> ITEM_CATEGORY_FLAGS = new LinkedHashMap();
    public static LinkedHashMap<GeologyMaterial, TagKey<Item>> ITEM_MATERIAL_HOLDER = new LinkedHashMap();
    public static LinkedHashMap<GeologyMaterial, TagKey<Block>> BLOCK_MATERIAL_HOLDER = new LinkedHashMap();
    public static LinkedHashMap<BlockCategoryFlags, TagKey<Block>> BLOCK_CATEGORY_FLAGS = new LinkedHashMap();
    private static boolean initialized = false;

    public static synchronized void initialize() {
        TagKey key;
        IGLib.IG_LOGGER.info("======== Initializing Immersive Geology Tags ========");
        for (ItemCategoryFlags itemFlag : ItemCategoryFlags.values()) {
            ITEM_TAG_HOLDER.put(itemFlag, new LinkedHashMap());
            for (MaterialInterface materialInterface : IGLib.getGeologyMaterials()) {
                if (!materialInterface.hasFlag(itemFlag)) continue;
                IGTags.createWrapperForCategory(itemFlag, new GeologyMaterial[]{materialInterface.instance()});
            }
            key = ItemTags.create((ResourceLocation)new ResourceLocation("forge", itemFlag.getName().toLowerCase() + itemFlag.getTagPrefix()));
            ITEM_CATEGORY_FLAGS.put(itemFlag, (TagKey<Item>)key);
        }
        for (MaterialInterface materialInterface : IGLib.getGeologyMaterials()) {
            TagKey key2 = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "material/" + materialInterface.getName().toLowerCase()));
            ITEM_MATERIAL_HOLDER.put((GeologyMaterial)materialInterface.instance(), (TagKey<Item>)key2);
            TagKey blockKey = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "material/" + materialInterface.getName().toLowerCase()));
            BLOCK_MATERIAL_HOLDER.put((GeologyMaterial)materialInterface.instance(), (TagKey<Block>)blockKey);
        }
        for (BlockCategoryFlags blockFlag : BlockCategoryFlags.values()) {
            key = BlockTags.create((ResourceLocation)new ResourceLocation("forge", blockFlag.getName().toLowerCase() + blockFlag.getTagPrefix()));
            BLOCK_CATEGORY_FLAGS.put(blockFlag, (TagKey<Block>)key);
        }
        FLUID_TAG_HOLDER.put(BlockCategoryFlags.FLUID, new LinkedHashMap());
        FLUID_TAG_HOLDER.put(BlockCategoryFlags.SLURRY, new LinkedHashMap());
        FLUID_TAG_HOLDER.put(BlockCategoryFlags.CLOUDY_SLURRY, new LinkedHashMap());
        HashMap fluid_map = FLUID_TAG_HOLDER.get(BlockCategoryFlags.FLUID);
        HashMap hashMap = FLUID_TAG_HOLDER.get(BlockCategoryFlags.SLURRY);
        HashMap cloud_slurry_map = FLUID_TAG_HOLDER.get(BlockCategoryFlags.CLOUDY_SLURRY);
        LinkedHashSet<MetalEnum> slurry_material_set = new LinkedHashSet<MetalEnum>(List.of(MetalEnum.values()));
        slurry_material_set.addAll(List.of(MineralEnum.values()));
        for (MaterialInterface materialInterface : IGLib.getGeologyMaterials()) {
            Object tag;
            Object base_set;
            if (materialInterface.hasFlag(BlockCategoryFlags.FLUID)) {
                String registryKey = BlockCategoryFlags.FLUID.getRegistryKey(materialInterface);
                if (!IGRegistrationHolder.getFluidRegistryMap().containsKey(registryKey)) {
                    IGLib.IG_LOGGER.info("Skipping Fluid name {} as it is not in the Fluid Registration Map", (Object)registryKey);
                    continue;
                }
                Object t = materialInterface.instance();
                TagKey tag2 = FluidTags.create((ResourceLocation)new ResourceLocation("forge", t.getName().toLowerCase()));
                base_set = new LinkedHashSet();
                ((HashSet)base_set).add(t);
                fluid_map.put(IGTags.getWrapFromSet((LinkedHashSet<MaterialHelper>)base_set), tag2);
            }
            if (materialInterface.hasFlag(BlockCategoryFlags.SLURRY)) {
                for (MaterialInterface materialInterface2 : slurry_material_set) {
                    MaterialChemical chemical;
                    base_set = materialInterface.instance();
                    if (!(base_set instanceof MaterialChemical) || !(chemical = (MaterialChemical)base_set).hasSlurryWith(materialInterface2)) continue;
                    String registryKey = BlockCategoryFlags.SLURRY.getRegistryKey(materialInterface, materialInterface2);
                    if (!IGRegistrationHolder.getFluidRegistryMap().containsKey(registryKey)) {
                        IGLib.IG_LOGGER.info("Skipping Slurry name {} as it is not in the Fluid Registration Map", (Object)registryKey);
                        continue;
                    }
                    Object base = materialInterface.instance();
                    tag = FluidTags.create((ResourceLocation)new ResourceLocation("forge", "clean_" + base.getName().toLowerCase() + "_" + materialInterface2.getName().toLowerCase()));
                    LinkedHashSet<MaterialHelper> base_set2 = new LinkedHashSet<MaterialHelper>();
                    base_set2.add((MaterialHelper)base);
                    base_set2.add((MaterialHelper)materialInterface2.instance());
                    hashMap.put(IGTags.getWrapFromSet(BlockCategoryFlags.SLURRY, base_set2), tag);
                }
            }
            if (!materialInterface.hasFlag(BlockCategoryFlags.CLOUDY_SLURRY)) continue;
            for (MineralEnum slurry_material : MineralEnum.values()) {
                MaterialChemical chemical;
                tag = materialInterface.instance();
                if (!(tag instanceof MaterialChemical) || !(chemical = (MaterialChemical)tag).hasSlurryWith(slurry_material)) continue;
                String registryKey = BlockCategoryFlags.CLOUDY_SLURRY.getRegistryKey(materialInterface, slurry_material);
                if (!IGRegistrationHolder.getFluidRegistryMap().containsKey(registryKey)) {
                    IGLib.IG_LOGGER.info("Skipping CLOUDY_SLURRY name {} as it is not in the Fluid Registration Map", (Object)registryKey);
                    continue;
                }
                Object base = materialInterface.instance();
                TagKey tag3 = FluidTags.create((ResourceLocation)new ResourceLocation("forge", "cloudy_" + base.getName().toLowerCase() + "_" + slurry_material.getName().toLowerCase()));
                LinkedHashSet<MaterialHelper> base_set3 = new LinkedHashSet<MaterialHelper>();
                base_set3.add((MaterialHelper)base);
                base_set3.add((MaterialHelper)slurry_material.instance());
                cloud_slurry_map.put(IGTags.getWrapFromSet(BlockCategoryFlags.CLOUDY_SLURRY, base_set3), tag3);
            }
        }
        initialized = true;
        IGLib.IG_LOGGER.info("Finished");
    }

    private static void createWrapperForCategory(IFlagType<?> category, GeologyMaterial ... materials) {
        Object obj;
        if (Arrays.stream(materials).anyMatch(m -> m.hasFlag(category)) && (obj = category.getValue()) instanceof ItemCategoryFlags) {
            ItemCategoryFlags itemFlag = (ItemCategoryFlags)obj;
            HashMap map = ITEM_TAG_HOLDER.get(itemFlag);
            LinkedHashSet<MaterialHelper> materialSet = new LinkedHashSet<MaterialHelper>(Arrays.asList(materials));
            map.put(IGTags.getWrapFromSet(materialSet), ItemTags.create((ResourceLocation)IGTags.wrapCategory(itemFlag, materialSet)));
        }
    }

    private static ResourceLocation wrapCategory(IFlagType<?> category, HashSet<MaterialHelper> materialSet) {
        StringJoiner material_set_name = new StringJoiner("_");
        materialSet.forEach(m -> material_set_name.add(m.getName()));
        return new ResourceLocation("forge", category.getName() + category.getTagPrefix() + "/" + String.valueOf(material_set_name));
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getWrapFromSet(LinkedHashSet<MaterialHelper> matSet) {
        StringJoiner value = new StringJoiner(",");
        for (MaterialHelper m : matSet) {
            value.add(m.getName());
        }
        return "[" + String.valueOf(value) + "]";
    }

    public static String getWrapFromSet(IFlagType<?> base, LinkedHashSet<MaterialHelper> matSet) {
        StringJoiner value = new StringJoiner(",");
        value.add(base.getName().toLowerCase());
        for (MaterialHelper m : matSet) {
            value.add(m.getName());
        }
        return "[" + String.valueOf(value) + "]";
    }
}

