/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world;

import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.world.IGWorldGen;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.mojang.serialization.Codec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraftforge.common.util.Lazy;

public class IGHeightProvider
extends HeightProvider {
    public static final Codec<IGHeightProvider> CODEC = IWorldGenConfig.CODEC.xmap(IGHeightProvider::new, p -> p.entry);
    private final IWorldGenConfig entry;
    private final Lazy<HeightProvider> internalProvider;

    public IGHeightProvider(IWorldGenConfig entry) {
        this.entry = entry;
        this.internalProvider = Lazy.of(() -> {
            IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(entry);
            if (config != null) {
                VerticalAnchor vaMin = pContext -> (Integer)config.minY.get();
                VerticalAnchor vaMax = pContext -> (Integer)config.maxY.get();
                return UniformHeight.m_162034_((VerticalAnchor)vaMin, (VerticalAnchor)vaMax);
            }
            IGServerConfig.Evaporates.EvaporateConfig evaporateConfig = IGServerConfig.EVAPORITES.evaporates.get(entry);
            if (evaporateConfig != null) {
                VerticalAnchor vaMin = pContext -> (Integer)evaporateConfig.minY.get();
                VerticalAnchor vaMax = pContext -> (Integer)evaporateConfig.maxY.get();
                return UniformHeight.m_162034_((VerticalAnchor)vaMin, (VerticalAnchor)vaMax);
            }
            IGLib.IG_LOGGER.error("Unable to find config for spawn height for spawner: {}", (Object)entry.getName());
            return UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)0));
        });
    }

    public int m_213859_(RandomSource random, WorldGenerationContext context) {
        return ((HeightProvider)this.internalProvider.get()).m_213859_(random, context);
    }

    public HeightProviderType<?> m_142002_() {
        return (HeightProviderType)IGWorldGen.IG_HEIGHT_PROVIDER.get();
    }
}

