/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world;

import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.core.lib.IGLib;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IGWorldSubscription {
    private static final BlockState stoneState = Blocks.f_50069_.m_49966_();
    private static final BlockState deepslateState = Blocks.f_152550_.m_49966_();
    private static final BlockState netherStone = Blocks.f_50134_.m_49966_();
    private static final List<BlockState> REMOVE_LIST_IRON = List.of(Blocks.f_49996_.m_49966_(), Blocks.f_152468_.m_49966_(), Blocks.f_152598_.m_49966_());
    private static final List<BlockState> REMOVE_LIST_COPPER = List.of(Blocks.f_152505_.m_49966_(), Blocks.f_152506_.m_49966_(), Blocks.f_152599_.m_49966_());
    private static final List<BlockState> REMOVE_LIST_GOLD = List.of(Blocks.f_49995_.m_49966_(), Blocks.f_152467_.m_49966_(), Blocks.f_152600_.m_49966_(), Blocks.f_49998_.m_49966_());
    private static Boolean removeIron = false;
    private static Boolean removeGold = false;
    private static Boolean removeCopper = false;
    private static IGServerConfig.Ores oreConfigs = null;
    private final Predicate<BlockState> isReplaceable = blockState -> removeIron != false && REMOVE_LIST_IRON.contains(blockState) || removeCopper != false && REMOVE_LIST_COPPER.contains(blockState) || removeGold != false && REMOVE_LIST_GOLD.contains(blockState);
    private static int chunksProcessed = 0;
    private final ArrayDeque<Long> last100ProcessingTimes = new ArrayDeque(100);

    public static void getConfigValues() {
        removeIron = (Boolean)IGServerConfig.REMOVAL.shouldRemoveIron.get();
        removeCopper = (Boolean)IGServerConfig.REMOVAL.shouldRemoveCopper.get();
        removeGold = (Boolean)IGServerConfig.REMOVAL.shouldRemoveGold.get();
        oreConfigs = IGServerConfig.ORES;
    }

    @SubscribeEvent
    public void levelLoad(LevelEvent.Load event) {
        chunksProcessed = 0;
        IGWorldSubscription.getConfigValues();
    }

    private Set<ResourceLocation> getBlacklistedBiomes() {
        return ((List)IGServerConfig.REMOVAL.biome_blacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
    }

    @SubscribeEvent
    public void forceRemoveVanillaVeins(ChunkEvent.Load event) {
        Holder holder;
        if (!event.isNewChunk()) {
            return;
        }
        long startTime = 0L;
        boolean canLog = (Boolean)IGServerConfig.REMOVAL.logProcess.get();
        if (canLog) {
            startTime = System.nanoTime();
        }
        boolean isNether = false;
        boolean chunkModified = false;
        BlockState replaceState = null;
        ChunkAccess chunk = event.getChunk();
        LevelAccessor level = event.getLevel();
        if (!(removeIron.booleanValue() || removeCopper.booleanValue() || removeGold.booleanValue())) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            isNether = slevel.m_46472_().equals((Object)Level.f_46429_);
            Object object = replaceState = isNether ? netherStone : null;
        }
        if ((holder = level.m_204166_(chunk.m_7697_().m_45615_())).getTagKeys().anyMatch(b -> {
            if (this.getBlacklistedBiomes().contains(b.f_203868_())) {
                if (canLog) {
                    IGLib.IG_LOGGER.info("Operation not permitted within {}", (Object)b.f_203868_());
                    IGLib.IG_LOGGER.info("Change Server Configuration File if this is not desired");
                }
                return true;
            }
            return false;
        })) {
            return;
        }
        for (int sectionY = chunk.m_151560_(); sectionY < chunk.m_151561_(); ++sectionY) {
            int sectionIndex = chunk.m_151566_(sectionY);
            LevelChunkSection section = chunk.m_183278_(sectionIndex);
            if (section.m_188008_() || !section.m_63002_(this.isReplaceable)) continue;
            chunkModified = true;
            int minY = SectionPos.m_123196_((ChunkPos)chunk.m_7697_(), (int)sectionY).m_123234_();
            if (!isNether) {
                if (minY + 16 < 0) {
                    replaceState = deepslateState;
                }
                if (minY > 0) {
                    replaceState = stoneState;
                }
            }
            for (int y = 0; y < 16; ++y) {
                if (replaceState == null) {
                    int worldY = minY + y;
                    replaceState = worldY < 0 ? deepslateState : stoneState;
                }
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState currentState = section.m_62982_(x, y, z);
                        boolean replace = this.isReplaceable.test(currentState);
                        if (!replace) continue;
                        section.m_62986_(x, y, z, replaceState);
                    }
                }
            }
        }
        if (chunkModified) {
            chunk.m_8092_(true);
        }
        if (canLog) {
            long endTime = System.nanoTime();
            long processingTime = endTime - startTime;
            ++chunksProcessed;
            if (this.last100ProcessingTimes.size() >= 100) {
                this.last100ProcessingTimes.pollFirst();
            }
            this.last100ProcessingTimes.addLast(processingTime);
            if (chunksProcessed % 100 == 0) {
                ArrayList<Long> sortedTimes = new ArrayList<Long>(this.last100ProcessingTimes);
                Collections.sort(sortedTimes);
                int size = sortedTimes.size();
                double medianTimeMs = size % 2 == 0 ? (double)((Long)sortedTimes.get(size / 2 - 1) + (Long)sortedTimes.get(size / 2)) / 2.0 / 1000000.0 : (double)((Long)sortedTimes.get(size / 2)).longValue() / 1000000.0;
                IGLib.IG_LOGGER.info("Processed {} chunks. Median processing time for last 100 chunks: {} ms per chunk", (Object)chunksProcessed, (Object)String.format("%.6f", medianTimeMs));
            }
        }
    }
}

