/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world;

import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public interface IWorldGenConfig {
    public static final Codec<IWorldGenConfig> CODEC = Codec.STRING.xmap(IWorldGenConfig::getValue, IWorldGenConfig::name);

    public int getVeinSize();

    public int getMinY();

    public int getMaxY();

    public int veinsPerChunk();

    public int rarity();

    public int generationChance();

    public double density();

    public boolean useSparsePlacement();

    public Optional<TagKey<Biome>> getPreferredBiome();

    public GeologyMaterial instance();

    public IOreBlock getOreBlock(StoneEnum var1, OreRichness var2);

    public BlockState getDefaultBlockstate();

    public String name();

    public static IWorldGenConfig getValue(String e) {
        Enum v = null;
        try {
            v = MineralEnum.valueOf(e);
        }
        catch (Exception ex) {
            try {
                v = MetalEnum.valueOf(e);
                if (!v.instance().hasFlag(BlockCategoryFlags.ORE_BLOCK)) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public String getName();

    default public IGGenerationType getGenerationType() {
        return IGGenerationType.DEFAULT;
    }

    public double getAssociateMaterialChance();

    public Set<Pair<Function<Integer, MaterialHelper>, Integer>> getAssociateMaterialSet();

    public double getMinSpawnTemp();

    public double getMaxSpawnTemp();

    public double getMinDownfall();

    public double getMaxDownfall();

    public long seed();

    default public List<String> getDefaultDimensions() {
        return this.instance().getAcceptableDimensions();
    }
}

