/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.features;

import com.igteam.immersivegeology.common.block.ore.IGWeatheringOreBlock;
import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.common.world.features.helper.IGOreGenUtils;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.common.world.noise.INoise3D;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class IGOreFeature
extends Feature<IGOreFeatureConfig> {
    public static final float THRESHOLD = 0.4f;

    public IGOreFeature() {
        super(IGOreFeatureConfig.CODEC.codec());
    }

    public boolean m_142674_(FeaturePlaceContext<IGOreFeatureConfig> ctx) {
        IGOreFeatureConfig config = (IGOreFeatureConfig)ctx.m_159778_();
        WorldGenLevel level = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        ChunkPos chunkPos = new ChunkPos(pos);
        Objects.requireNonNull(level);
        IGServerConfig.Ores.OreConfig rConfig = IGServerConfig.ORES.ores.get(config.entry());
        RandomSource random = IGOreGenUtils.getReuseRandom(config.entry, level.m_7328_(), chunkPos);
        Vein vein = IGOreFeature.createVein(random, rConfig, config.entry);
        IGOreFeature.placeVein((LevelAccessor)level, random, chunkPos, vein, config);
        return true;
    }

    public static String formatTime(long timeInNanoSeconds) {
        long seconds = timeInNanoSeconds / 1000000000L;
        long milliseconds = timeInNanoSeconds % 1000000000L / 1000000L;
        long microseconds = timeInNanoSeconds % 1000000L / 1000L;
        return String.format("%d seconds, %d milliseconds, %d microseconds", seconds, milliseconds, microseconds);
    }

    public static Vein createVein(RandomSource random, IGServerConfig.Ores.OreConfig config, IWorldGenConfig material) {
        int FEATURE_SIZE = (Integer)config.veinSize.get();
        INoise3D noise = ((IGGenerationType)((Object)config.generationPattern.get())).getPattern().getiNoise3D(FEATURE_SIZE, material.seed());
        return new Vein(IGOreFeature.defaultPosRespectingHeight(random, config), noise, material);
    }

    private static BlockPos defaultPosRespectingHeight(RandomSource random, IGServerConfig.Ores.OreConfig config) {
        return new BlockPos(random.m_188503_(16), IGOreFeature.defaultYPos((Integer)config.veinSize.get(), random, config), random.m_188503_(16));
    }

    protected static int defaultYPos(int verticalShrinkRange, RandomSource random, IGServerConfig.Ores.OreConfig config) {
        int actualRange = (Integer)config.maxY.get() - (Integer)config.minY.get() - 2 * verticalShrinkRange;
        return actualRange > 0 ? (Integer)config.minY.get() + verticalShrinkRange + random.m_188503_(actualRange) : ((Integer)config.minY.get() + (Integer)config.maxY.get()) / 2;
    }

    private static MaterialHelper getFriendMaterial(RandomSource random, int height, Set<Pair<Function<Integer, MaterialHelper>, Integer>> friends) {
        float totalWeight = 0.0f;
        for (Pair<Function<Integer, MaterialHelper>, Integer> entry : friends) {
            totalWeight += (float)((Integer)entry.getSecond()).intValue();
        }
        float randomValue = random.m_188501_() * totalWeight;
        for (Pair<Function<Integer, MaterialHelper>, Integer> entry : friends) {
            if (!((randomValue -= (float)((Integer)entry.getSecond()).intValue()) <= 0.0f)) continue;
            return (MaterialHelper)((Function)entry.getFirst()).apply(height);
        }
        return null;
    }

    public static void placeVein(LevelAccessor level, RandomSource random, ChunkPos centerChunk, Vein vein, IGOreFeatureConfig config) {
        int veinMinY = config.entry().getMinY();
        int veinMaxY = config.entry().getMaxY();
        double associateChance = (Double)config.getConfig().associateChance.get();
        MaterialInterface parentMaterial = (MaterialInterface)((Object)config.entry);
        Set<Pair<Function<Integer, MaterialHelper>, Integer>> friends = ((GeologyMaterial)parentMaterial.instance()).getAssociateMaterialSet();
        int sectionMin = level.m_151564_(Math.max(veinMinY, level.m_141937_()));
        int sectionMax = level.m_151564_(Math.min(veinMaxY, level.m_151558_()));
        for (int chunkDX = -1; chunkDX <= 1; ++chunkDX) {
            for (int chunkDZ = -1; chunkDZ <= 1; ++chunkDZ) {
                ChunkPos currentChunkPos = new ChunkPos(centerChunk.f_45578_ + chunkDX, centerChunk.f_45579_ + chunkDZ);
                ChunkAccess currentChunk = level.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
                for (int sectionIndex = sectionMin; sectionIndex < sectionMax; ++sectionIndex) {
                    LevelChunkSection section = currentChunk.m_183278_(sectionIndex);
                    if (section.m_188008_() || !section.m_63002_(b -> IGOreGenUtils.canStateGenerate(b, parentMaterial.instance()))) continue;
                    int sectionMinY = SectionPos.m_123223_((int)sectionIndex);
                    int sectionMaxY = sectionMinY + 15;
                    IGOreFeature.processChunkSection(level, random, currentChunk, sectionMinY, sectionMaxY, vein, associateChance, config.getDensity(), parentMaterial, friends, centerChunk);
                }
            }
        }
    }

    private static void processChunkSection(LevelAccessor level, RandomSource random, ChunkAccess chunk, int minY, int maxY, Vein vein, double associateChance, double density, MaterialInterface<?> parentMaterial, Set<Pair<Function<Integer, MaterialHelper>, Integer>> friends, ChunkPos centerChunkPos) {
        ChunkPos chunkPos = chunk.m_7697_();
        for (int y = minY; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockState oreState;
                    BlockState stoneState;
                    if (density < (double)random.m_188501_()) continue;
                    boolean useFriendMaterials = associateChance > random.m_188500_();
                    MaterialHelper reusableFriendMaterial = useFriendMaterials ? IGOreFeature.getFriendMaterial(random, y, friends) : null;
                    BlockPos pos = chunkPos.m_151384_(x, y, z);
                    double noiseValue = IGOreGenUtils.noise(chunkPos, x, y, z, vein, centerChunkPos);
                    if (!(noiseValue > (double)0.4f) || (stoneState = chunk.m_8055_(new BlockPos(x, y, z))).m_60795_()) continue;
                    Object useMaterial = parentMaterial.instance();
                    if (useFriendMaterials && reusableFriendMaterial != null) {
                        useMaterial = reusableFriendMaterial;
                    }
                    if ((oreState = IGOreGenUtils.getStateToGenerate(stoneState, noiseValue, useMaterial)) == null) continue;
                    if (oreState.m_60734_() instanceof IGWeatheringOreBlock) {
                        oreState = IGOreGenUtils.oxidizeExposed(level, chunkPos.m_151384_(x, y, z), oreState);
                    }
                    chunk.m_6978_(pos, oreState, false);
                }
            }
        }
    }

    public record IGOreFeatureConfig(IWorldGenConfig entry, long seed, double temp_range_min, double temp_range_max, double downfall_min, double downfall_max) implements FeatureConfiguration
    {
        public static final MapCodec<IGOreFeatureConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IWorldGenConfig.CODEC.fieldOf("entry").forGetter(c -> c.entry), (App)Codec.either((Codec)Codec.STRING, (Codec)Codec.LONG).xmap(e -> (Long)e.map(IGOreFeatureConfig::hash, l -> l), Either::right).fieldOf("random_name").forGetter(c -> c.seed), (App)Codec.DOUBLE.fieldOf("temp_range_min").forGetter(c -> c.temp_range_min), (App)Codec.DOUBLE.fieldOf("temp_range_max").forGetter(c -> c.temp_range_max), (App)Codec.DOUBLE.fieldOf("downfall_min").forGetter(c -> c.downfall_min), (App)Codec.DOUBLE.fieldOf("downfall_max").forGetter(c -> c.downfall_max)).apply((Applicative)instance, IGOreFeatureConfig::new));
        private static final Map<String, Long> HASH_CACHE = new ConcurrentHashMap<String, Long>();

        public int getSize() {
            return (Integer)this.getConfig().veinSize.get();
        }

        public static long hash(String name) {
            return HASH_CACHE.computeIfAbsent(name, k -> {
                RandomSupport.Seed128bit seed128 = RandomSupport.m_288212_((String)k);
                return seed128.f_189335_() ^ seed128.f_189336_();
            });
        }

        public int getRarity() {
            return (Integer)this.getConfig().rarity.get();
        }

        public IGServerConfig.Ores.OreConfig getConfig() {
            return IGServerConfig.ORES.ores.get(this.entry);
        }

        public IWorldGenConfig type() {
            return this.entry;
        }

        public int getChanceToGenerate() {
            IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(this.entry);
            return (Integer)config.generationChance.get();
        }

        public double getDensity() {
            IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(this.entry);
            return (Double)config.density.get();
        }

        public boolean canSpawn() {
            IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(this.entry);
            return (Boolean)config.canSpawn.get();
        }
    }

    public record Vein(BlockPos pos, INoise3D noise, IWorldGenConfig material) {
        public INoise3D getNoise() {
            return this.noise;
        }

        public IWorldGenConfig getMaterial() {
            return this.material;
        }
    }
}

