/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.features.helper;

import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.block.ore.IGOreBlock;
import com.igteam.immersivegeology.common.block.ore.IGWeatheringOreBlock;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.common.world.features.IGOreFeature;
import com.igteam.immersivegeology.common.world.noise.INoise3D;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class IGOreGenUtils {
    private static final Direction[] DIRECTIONS = Direction.values();
    static TagKey<Block> stoneTag = Tags.Blocks.STONE;
    static TagKey<Block> endStoneTag = Tags.Blocks.END_STONES;
    static TagKey<Block> netherackTag = Tags.Blocks.NETHERRACK;
    static BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public static BlockState getStateToGenerate(BlockState stoneState, double noiseValue, MaterialHelper mineral) {
        StoneEnum stone = null;
        stone = stoneState.m_60713_(Blocks.f_50134_) ? StoneEnum.MCNetherrack : (stoneState.m_60713_(Blocks.f_50137_) ? StoneEnum.MCBasalt : (stoneState.m_60713_(Blocks.f_50259_) ? StoneEnum.MCEndStone : StoneEnum.selectWorldState(stoneState)));
        if (stone == null || !stone.isStoneTypeValid() || !mineral.acceptableStoneType(stone.instance())) {
            return null;
        }
        try {
            OreRichness richness = noiseValue > 0.99 ? OreRichness.RICH : (noiseValue > 0.7 ? OreRichness.NORMAL : OreRichness.POOR);
            return mineral.getOreBlock(stone, richness).getIGDefaultBlockState();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean canStateGenerate(BlockState stoneState, MaterialHelper mineral) {
        if (stoneState.m_60713_(Blocks.f_50069_)) {
            return mineral.acceptableStoneType(StoneEnum.MCStone);
        }
        if (stoneState.m_60713_(Blocks.f_50134_)) {
            return mineral.acceptableStoneType(StoneEnum.MCNetherrack);
        }
        if (stoneState.m_60713_(Blocks.f_50137_)) {
            return mineral.acceptableStoneType(StoneEnum.MCBasalt);
        }
        if (stoneState.m_60713_(Blocks.f_50259_)) {
            return mineral.acceptableStoneType(StoneEnum.MCEndStone);
        }
        StoneEnum stone = StoneEnum.selectWorldState(stoneState);
        return stone != null && stone.isStoneTypeValid() && mineral.acceptableStoneType(stone.instance());
    }

    public static BlockState oxidizeExposed(LevelAccessor level, BlockPos cursor, BlockState oreState) {
        if (oreState.m_60734_().m_6724_(oreState)) {
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                Direction direction = DIRECTIONS[i];
                EnumProperty<MineralWeathering> oxidationProperty = IGWeatheringOreBlock.OXIDATION_PROPERTIES.get(i);
                BlockPos adjacentPos = cursor.m_121955_(direction.m_122436_());
                oreState = IGOreGenUtils.handleOxidation(oreState, level, adjacentPos, oxidationProperty);
            }
        }
        return oreState;
    }

    public static BlockState handleOxidation(BlockState state, LevelAccessor level, BlockPos adjacentPos, EnumProperty<MineralWeathering> oxidationProperty) {
        BlockState adjState = level.m_8055_(adjacentPos);
        if (!adjState.m_60838_((BlockGetter)level, adjacentPos)) {
            return (BlockState)state.m_61124_(oxidationProperty, (Comparable)((Object)MineralWeathering.CORRODED));
        }
        if (level.m_8055_(adjacentPos).m_60713_(Blocks.f_49990_)) {
            return (BlockState)state.m_61124_(oxidationProperty, (Comparable)((Object)MineralWeathering.TARNISHED));
        }
        return state;
    }

    public static float getWorthwhileCount(LevelAccessor level, ChunkPos centerChunk, int maxY, int minY, IGOreFeature.Vein vein) {
        int totalViableLocations = 0;
        try {
            int sectionMin = level.m_151564_(Math.max(minY, level.m_141937_()));
            int sectionMax = level.m_151564_(Math.min(maxY, level.m_151558_()));
            if (sectionMin < 0) {
                throw new IllegalArgumentException("Section Min is Negative, this should be impossible. \nPlease report to Immerisve Geology Github or Discord. \nInclude the Dimension and Biome you're in when triggering this message");
            }
            for (int chunkDX = -1; chunkDX <= 1; ++chunkDX) {
                for (int chunkDZ = -1; chunkDZ <= 1; ++chunkDZ) {
                    ChunkPos currentChunkPos = new ChunkPos(centerChunk.f_45578_ + chunkDX, centerChunk.f_45579_ + chunkDZ);
                    ChunkAccess currentChunk = level.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
                    for (int sectionIndex = sectionMin; sectionIndex < sectionMax; ++sectionIndex) {
                        LevelChunkSection section = currentChunk.m_183278_(sectionIndex);
                        if (section.m_188008_() || !section.m_63002_(b -> b.m_204336_(stoneTag) || b.m_204336_(netherackTag) || b.m_204336_(endStoneTag))) continue;
                        int sectionMinY = SectionPos.m_123223_((int)sectionIndex);
                        int sectionMaxY = sectionMinY + 15;
                        totalViableLocations += IGOreGenUtils.countViableLocationsInSection(currentChunk, sectionMinY, sectionMaxY, vein, centerChunk);
                    }
                }
            }
            int areaMinY = SectionPos.m_123223_((int)sectionMin);
            int areaMaxY = SectionPos.m_123223_((int)sectionMax);
            int totalBlocks = 2304 * Math.abs(areaMinY - areaMaxY);
            return (float)totalViableLocations / (float)totalBlocks;
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                IGLib.IG_LOGGER.info("Error in vein estimation: {}", (Object)ex.getMessage());
            }
            return 0.0f;
        }
    }

    private static int countViableLocationsInSection(ChunkAccess chunk, int minY, int maxY, IGOreFeature.Vein vein, ChunkPos centreChunk) {
        int viablePositions = 0;
        ChunkPos chunkPos = chunk.m_7697_();
        for (int y = minY; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    boolean viable;
                    double noiseValue = IGOreGenUtils.noise(chunkPos, x, y, z, vein, centreChunk);
                    if (!(noiseValue > (double)0.4f)) continue;
                    mutablePos.m_122178_(x, y, z);
                    BlockState state = chunk.m_8055_((BlockPos)mutablePos);
                    boolean bl = viable = state.m_204336_(stoneTag) || state.m_204336_(endStoneTag) || state.m_204336_(netherackTag) || state.m_60734_() instanceof IGOreBlock;
                    if (!viable) continue;
                    ++viablePositions;
                }
            }
        }
        return viablePositions;
    }

    public static double noise(ChunkPos pos, int x, int y, int z, @NotNull IGOreFeature.Vein vein, ChunkPos centerChunkPos) {
        INoise3D noiseGen = vein.noise();
        BlockPos middleBlockPosition = centerChunkPos.m_151394_(0);
        BlockPos currentBlockPosition = pos.m_151384_(x, y, z);
        double dx = currentBlockPosition.m_123341_() - middleBlockPosition.m_123341_();
        double dz = currentBlockPosition.m_123343_() - middleBlockPosition.m_123343_();
        double horizontalDistance = Math.hypot(dx, dz);
        double radius = 24.0;
        double outerThreshold = 16.0;
        double boundaryMultiplication = IGOreGenUtils.getBoundaryMultiplication(horizontalDistance, outerThreshold, radius);
        return (double)noiseGen.noise(currentBlockPosition) * boundaryMultiplication;
    }

    private static double getBoundaryMultiplication(double horizontalDistance, double outerThreshold, double radius) {
        double middleThreshold = 20.0;
        double boundaryMultiplication = 1.0;
        if (horizontalDistance > outerThreshold) {
            if (horizontalDistance > middleThreshold) {
                double t = (horizontalDistance - middleThreshold) / (radius - middleThreshold);
                boundaryMultiplication = 0.5 * (1.0 - t);
            } else {
                double t = (horizontalDistance - outerThreshold) / (middleThreshold - outerThreshold);
                boundaryMultiplication = 0.75 - 0.25 * t;
            }
        }
        boundaryMultiplication = Math.max(0.0, boundaryMultiplication);
        return boundaryMultiplication;
    }

    public static boolean isVeinWorthwhile(LevelAccessor level, ChunkPos chunk, int maxY, int minY, IGOreFeature.Vein vein) {
        float totalViableLocations = IGOreGenUtils.getWorthwhileCount(level, chunk, maxY, minY, vein);
        return Math.floor(totalViableLocations * 100.0f) > 0.0;
    }

    public static RandomSource getReuseRandom(IWorldGenConfig material, long level_seed, ChunkPos position) {
        return new XoroshiroRandomSource((level_seed ^ (long)position.f_45578_) * 61728364132L, (material.seed() ^ (long)position.f_45579_) * 16298364123L);
    }
}

