/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.modifiers;

import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.world.IGWorldGen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record IGOreRemovalModifier() implements BiomeModifier
{
    private static final ForgeConfigSpec.BooleanValue isDebugLogEnabled = IGServerConfig.REMOVAL.logProcess;

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)IGWorldGen.ORE_MODIFIER_CODEC.get();
    }

    private Set<ResourceLocation> getBlacklistedBiomes() {
        return ((List)IGServerConfig.REMOVAL.biome_blacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
    }

    public void modify(Holder<Biome> holder, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE) {
            boolean canLog = (Boolean)isDebugLogEnabled.get();
            if (holder.getTagKeys().anyMatch(b -> {
                if (this.getBlacklistedBiomes().contains(b.f_203868_())) {
                    if (canLog) {
                        IGLib.IG_LOGGER.info("Ore Removal Operation not permitted in Biomes with the '{}' tag", b);
                        IGLib.IG_LOGGER.info("Change Server Configuration File if this is not desired");
                    }
                    return true;
                }
                return false;
            })) {
                return;
            }
            ArrayList<String> oresToRemove = new ArrayList<String>();
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveIron.get()).booleanValue()) {
                oresToRemove.add("minecraft:ore_iron");
                oresToRemove.add("minecraft:ore_iron_small");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveCopper.get()).booleanValue()) {
                oresToRemove.add("minecraft:ore_copper_small");
                oresToRemove.add("minecraft:ore_copper_large");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveGold.get()).booleanValue()) {
                oresToRemove.add("minecraft:ore_gold");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveIEBauxite.get()).booleanValue()) {
                oresToRemove.add("immersiveengineering:bauxite");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveIELead.get()).booleanValue()) {
                oresToRemove.add("immersiveengineering:lead");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveIESilver.get()).booleanValue()) {
                oresToRemove.add("immersiveengineering:silver");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveIEUranium.get()).booleanValue()) {
                oresToRemove.add("immersiveengineering:uranium");
            }
            if (((Boolean)IGServerConfig.REMOVAL.shouldRemoveIENickel.get()).booleanValue()) {
                oresToRemove.add("immersiveengineering:nickel");
                oresToRemove.add("immersiveengineering:deep_nickel");
            }
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            for (GenerationStep.Decoration step : GenerationStep.Decoration.values()) {
                List features = generationSettings.getFeatures(step);
                Objects.requireNonNull(features);
                features.removeIf(f -> {
                    if (f.m_203543_().isEmpty()) {
                        return false;
                    }
                    return oresToRemove.contains(((ResourceKey)f.m_203543_().get()).m_135782_().toString());
                });
            }
        }
    }
}

