/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.lib;

import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.MiscEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.energy.IEnergyStorage;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class IGLib {
    public static final String MODID = "immersivegeology";
    public static final Logger IG_LOGGER = new PrefixedLogger(LogUtils.getLogger(), "[IG] ");
    public static final int SLURRY_TO_CRYSTAL_MB = 144;
    public static final int ACID_RECOVERED_FROM_SLURRY = 120;
    public static final int ACID_TO_SLURRY_AMOUNT = 250;
    public static final int SLURRY_FROM_ACID_AMOUNT = 216;
    public static final int SULFUR_OUTGAS = 25;
    public static final float TWO_ACID_USED_MULTIPLIER = 0.5f;
    public static final float THREE_ACID_USED_MULTIPLIER = 0.5f;
    public static final int DUST_TO_SLURRY_AMOUNT = 1;
    public static final int COMPOUND_FROM_ACID_AMOUNT = 1;
    public static final int ACID_TO_COMPOUND_AMOUNT = 125;
    public static final int COMPOUND_ACID_TO_DUST_AMOUNT = 1;
    public static final int ACID_TO_DUST_AMOUNT = 125;
    public static final int DUST_FROM_COMPOUND_ACID_AMOUNT = 1;
    public static final String GUIID_Bloomery = "bloomery";
    public static final String GUIID_RevFurnace = "reverberation_furnace";
    public static final String GUIID_Crystallizer = "crystallizer";
    public static final String GUIID_ChemicalReactor = "chemical_reactor";
    public static final String GUIID_SmallChemicalReactor = "small_chemical_reactor";
    public static final String GUIID_RotaryKiln = "rotary_kiln";
    public static final String GUIID_GeothermalExchanger = "geothermal_exchanger";
    public static final String GUIID_Crate = "crate_menu";
    public static final int PELLETIZER_DEFAULT_TIME = 600;
    public static final BlockBehaviour.Properties STONE_DECO_PROPS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(2.0f, 10.0f);
    public static final BlockBehaviour.Properties CRYSTAL_DECO_PROPS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.PLING).m_60918_(SoundType.f_154654_).m_60999_().m_60913_(2.0f, 5.0f);
    public static final BlockBehaviour.Properties DEFAULT_METAL_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_154663_).m_60999_().m_60913_(3.0f, 15.0f);
    public static final BlockBehaviour.Properties SHEETMETAL_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(2.0f, 2.0f);
    public static final BlockBehaviour.Properties METAL_PROPERTIES_NO_OVERLAY = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60999_().m_60971_((state, blockReader, pos) -> false);
    public static final BlockBehaviour.Properties METAL_PROPERTIES_NO_OCCLUSION = METAL_PROPERTIES_NO_OVERLAY.m_60955_().m_280606_();

    public static Logger getNewLogger() {
        return new PrefixedLogger(LogUtils.getLogger(), "[IG] ");
    }

    public static LinkedList<MaterialInterface<?>> getGeologyMaterials() {
        LinkedList list = new LinkedList();
        list.addAll(List.of(StoneEnum.values()));
        list.addAll(List.of(MetalEnum.values()));
        list.addAll(List.of(MineralEnum.values()));
        list.addAll(List.of(MiscEnum.values()));
        list.addAll(List.of(ChemicalEnum.values()));
        return list;
    }

    public static LinkedList<MaterialInterface<?>> getGeneratedMaterials() {
        LinkedList list = new LinkedList();
        List<MetalEnum> metals = MetalEnum.generatedNativeMetals();
        List<MineralEnum> minerals = Arrays.stream(MineralEnum.values()).toList();
        list.addAll(metals);
        list.addAll(minerals);
        return list;
    }

    public static ResourceLocation rl(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static ResourceLocation makeTextureLocation(String name) {
        return IGLib.rl("textures/gui/" + name + ".png");
    }

    public static int fastHash(String s) {
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            hash = (hash << 5) - hash + s.charAt(i);
        }
        return hash;
    }

    public static int pushEnergy(IEnergyStorage provider, IEnergyStorage receiver, int maxAmount) {
        int energySim = provider.extractEnergy(maxAmount, true);
        int receivedSim = receiver.receiveEnergy(energySim, true);
        int energy = provider.extractEnergy(receivedSim, false);
        receiver.receiveEnergy(energy, false);
        return energy;
    }

    public static class PrefixedLogger
    implements Logger {
        private final Logger delegate;
        private final String prefix;

        public PrefixedLogger(Logger delegate, String prefix) {
            this.delegate = delegate;
            this.prefix = prefix;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isTraceEnabled() {
            return this.delegate.isTraceEnabled();
        }

        public void trace(String msg) {
            this.delegate.trace(this.prefix + msg);
        }

        public void trace(String format, Object arg) {
            this.delegate.trace(this.prefix + format, arg);
        }

        public void trace(String format, Object arg1, Object arg2) {
            this.delegate.trace(this.prefix + format, arg1, arg2);
        }

        public void trace(String format, Object ... arguments) {
            this.delegate.trace(this.prefix + format, arguments);
        }

        public void trace(String msg, Throwable t) {
            this.delegate.trace(this.prefix + msg, t);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.delegate.isTraceEnabled(marker);
        }

        public void trace(Marker marker, String msg) {
            this.delegate.trace(marker, this.prefix + msg);
        }

        public void trace(Marker marker, String format, Object arg) {
            this.delegate.trace(marker, this.prefix + format, arg);
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            this.delegate.trace(marker, this.prefix + format, arg1, arg2);
        }

        public void trace(Marker marker, String format, Object ... argArray) {
            this.delegate.trace(marker, this.prefix + format, argArray);
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.delegate.trace(marker, this.prefix + msg, t);
        }

        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        public void debug(String msg) {
            this.delegate.debug(this.prefix + msg);
        }

        public void debug(String format, Object arg) {
            this.delegate.debug(this.prefix + format, arg);
        }

        public void debug(String format, Object arg1, Object arg2) {
            this.delegate.debug(this.prefix + format, arg1, arg2);
        }

        public void debug(String format, Object ... arguments) {
            this.delegate.debug(this.prefix + format, arguments);
        }

        public void debug(String msg, Throwable t) {
            this.delegate.debug(this.prefix + msg, t);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.delegate.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String msg) {
            this.delegate.debug(marker, this.prefix + msg);
        }

        public void debug(Marker marker, String format, Object arg) {
            this.delegate.debug(marker, this.prefix + format, arg);
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            this.delegate.debug(marker, this.prefix + format, arg1, arg2);
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            this.delegate.debug(marker, this.prefix + format, arguments);
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.delegate.debug(marker, this.prefix + msg, t);
        }

        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        public void info(String msg) {
            this.delegate.info(this.prefix + msg);
        }

        public void info(String format, Object arg) {
            this.delegate.info(this.prefix + format, arg);
        }

        public void info(String format, Object arg1, Object arg2) {
            this.delegate.info(this.prefix + format, arg1, arg2);
        }

        public void info(String format, Object ... arguments) {
            this.delegate.info(this.prefix + format, arguments);
        }

        public void info(String msg, Throwable t) {
            this.delegate.info(this.prefix + msg, t);
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.delegate.isInfoEnabled(marker);
        }

        public void info(Marker marker, String msg) {
            this.delegate.info(marker, this.prefix + msg);
        }

        public void info(Marker marker, String format, Object arg) {
            this.delegate.info(marker, this.prefix + format, arg);
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.delegate.info(marker, this.prefix + format, arg1, arg2);
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.delegate.info(marker, this.prefix + format, arguments);
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.delegate.info(marker, this.prefix + msg, t);
        }

        public boolean isWarnEnabled() {
            return this.delegate.isWarnEnabled();
        }

        public void warn(String msg) {
            this.delegate.warn(this.prefix + msg);
        }

        public void warn(String format, Object arg) {
            this.delegate.warn(this.prefix + format, arg);
        }

        public void warn(String format, Object ... arguments) {
            this.delegate.warn(this.prefix + format, arguments);
        }

        public void warn(String format, Object arg1, Object arg2) {
            this.delegate.warn(this.prefix + format, arg1, arg2);
        }

        public void warn(String msg, Throwable t) {
            this.delegate.warn(this.prefix + msg, t);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.delegate.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String msg) {
            this.delegate.warn(marker, this.prefix + msg);
        }

        public void warn(Marker marker, String format, Object arg) {
            this.delegate.warn(marker, this.prefix + format, arg);
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.delegate.warn(marker, this.prefix + format, arg1, arg2);
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.delegate.warn(marker, this.prefix + format, arguments);
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.delegate.warn(marker, this.prefix + msg, t);
        }

        public boolean isErrorEnabled() {
            return this.delegate.isErrorEnabled();
        }

        public void error(String msg) {
            this.delegate.error(this.prefix + msg);
        }

        public void error(String format, Object arg) {
            this.delegate.error(this.prefix + format, arg);
        }

        public void error(String format, Object arg1, Object arg2) {
            this.delegate.error(this.prefix + format, arg1, arg2);
        }

        public void error(String format, Object ... arguments) {
            this.delegate.error(this.prefix + format, arguments);
        }

        public void error(String msg, Throwable t) {
            this.delegate.error(this.prefix + msg, t);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.delegate.isErrorEnabled(marker);
        }

        public void error(Marker marker, String msg) {
            this.delegate.error(marker, this.prefix + msg);
        }

        public void error(Marker marker, String format, Object arg) {
            this.delegate.error(marker, this.prefix + format, arg);
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.delegate.error(marker, this.prefix + format, arg1, arg2);
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.delegate.error(marker, this.prefix + format, arguments);
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.delegate.error(marker, this.prefix + msg, t);
        }
    }
}

