/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.google.common.collect.Sets;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.tag.IGTags;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.configuration.ConfigurationHelper;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialStone;
import com.igteam.immersivegeology.core.material.helper.HazardTypes;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class GeologyMaterial
implements MaterialHelper {
    public static ExistingFileHelper EXISTING_HELPER;
    protected String name;
    protected String unserialized_name;
    protected Logger logger = IGLib.getNewLogger();
    protected BiFunction<IFlagType<?>, Integer, Integer> colorFunction;
    protected BiPredicate<IFlagType<?>, Integer> applyColorTint;
    private final LinkedHashSet<IFlagType<?>> materialDataFlags = Sets.newLinkedHashSet();
    protected final List<Supplier<MultiblockHandler.IMultiblock>> validMultiblocks = new ArrayList<Supplier<MultiblockHandler.IMultiblock>>();
    protected Rarity materialRarity = Rarity.COMMON;
    protected IGRecipeChain directBlasting = new IGRecipeChain(this, "direct_blasting", 0);
    protected IGRecipeChain sulphideElectrowining = new IGRecipeChain(this, "sulphide_electrowining", 1);
    Set<Pair<Function<Integer, MaterialHelper>, Integer>> generation_group = new HashSet<Pair<Function<Integer, MaterialHelper>, Integer>>();
    private final LinkedHashSet<IGRecipeStage> stage_set = new LinkedHashSet();
    static Random rand;
    protected Set<StoneFormation> acceptableStoneTypes = new HashSet<StoneFormation>();
    private final Map<ModFlags, Map<IFlagType<?>, MaterialHelper>> EXISTING_IMPLEMENTATION_MAP = new HashMap();
    private float asocialMaterialChance = 1.0f;
    private int burntime = 0;

    public GeologyMaterial() {
        String className = this.getClass().getName();
        String classNameNormal = this.getClass().getName();
        this.name = className.substring(className.lastIndexOf(".") + 1).replace("Material", "").replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
        this.unserialized_name = classNameNormal.substring(classNameNormal.lastIndexOf(".") + 1).replace("Material", "");
        this.generation_group.add((Pair<Function<Integer, MaterialHelper>, Integer>)Pair.of(i -> this, (Object)100));
        this.colorFunction = this.materialColorFunction();
        this.initializeColorTint((p, integer) -> true);
        this.initializeFlags();
    }

    public Set<HazardTypes> getHazards() {
        return Set.of();
    }

    public BlockBehaviour.Properties getProperties(IFlagType<?> flag) {
        if (flag instanceof BlockCategoryFlags) {
            BlockCategoryFlags blockCategoryFlags = (BlockCategoryFlags)flag;
            return switch (blockCategoryFlags) {
                case BlockCategoryFlags.SHEETMETAL_BLOCK, BlockCategoryFlags.SHEETMETAL_SLAB, BlockCategoryFlags.SHEETMETAL_STAIRS -> IGLib.SHEETMETAL_PROPERTIES;
                case BlockCategoryFlags.STORAGE_BLOCK, BlockCategoryFlags.ENGINEERING_BLOCK, BlockCategoryFlags.ADVANCED_ENGINEERING_BLOCK -> IGLib.DEFAULT_METAL_PROPERTIES;
                case BlockCategoryFlags.SCAFFOLDING -> IGLib.METAL_PROPERTIES_NO_OCCLUSION;
                default -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_);
            };
        }
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_);
    }

    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of();
    }

    public void setRarity(Rarity rarity) {
        this.materialRarity = rarity;
    }

    public Rarity getRarity() {
        return this.materialRarity;
    }

    public void initializeFlags() {
        ArrayList flagList = new ArrayList();
        flagList.addAll(ConfigurationHelper.defaultItemFlags.apply(this));
        flagList.addAll(ConfigurationHelper.defaultBlockFlags.apply(this));
        for (IFlagType flag : flagList) {
            this.addFlags(flag);
        }
    }

    protected void addFlags(IFlagType<?> ... flags) {
        this.materialDataFlags.addAll(Arrays.asList(flags));
    }

    protected void removeMaterialFlags(IFlagType<?> ... flags) {
        Arrays.asList(flags).forEach(this.materialDataFlags::remove);
    }

    @Override
    public boolean hasFlag(IFlagType<?> flag) {
        return this.materialDataFlags.contains(flag);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getColor(IFlagType<?> p, Integer secondaryColors) {
        return this.applyColorTint.test(p, secondaryColors) ? this.colorFunction.apply(p, secondaryColors) : -1;
    }

    public void initializeColorTint(BiPredicate<IFlagType<?>, Integer> predicate) {
        this.applyColorTint = predicate;
    }

    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (flag, integer) -> -1;
    }

    public Set<IFlagType<?>> getFlags() {
        return this.materialDataFlags;
    }

    public ResourceLocation getTextureLocation(IFlagType<?> flag) {
        ResourceLocation texture = new ResourceLocation("immersivegeology", (flag instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + this.getName() + "/" + flag.toString().toLowerCase());
        if (!DatagenModLoader.isRunningDataGen()) {
            return this.greyScaleTextures(flag);
        }
        if (EXISTING_HELPER == null) {
            this.logger.info("Existing File Helper is Null, unable to query if textures exist");
            return this.greyScaleTextures(flag);
        }
        boolean exists = EXISTING_HELPER.exists(new ResourceLocation("immersivegeology", "textures/" + texture.m_135815_() + ".png"), PackType.CLIENT_RESOURCES);
        return exists ? texture : this.greyScaleTextures(flag);
    }

    protected ResourceLocation greyScaleTextures(IFlagType<?> pattern) {
        Object ore_overlay;
        Object obj = pattern.getValue();
        if (obj instanceof BlockCategoryFlags) {
            BlockCategoryFlags b = (BlockCategoryFlags)obj;
            return switch (b) {
                case BlockCategoryFlags.STORAGE_BLOCK -> new ResourceLocation("immersivegeology", "palette/block/" + b.getName() + "/type_" + this.getPaletteVariation(b) + "_pristine_" + this.getName().toLowerCase());
                case BlockCategoryFlags.ORE_BLOCK -> {
                    ore_overlay = this.getCrystalFamily() != null ? this.getCrystalFamily().getName() : "vanilla_normal";
                    yield new ResourceLocation("immersivegeology", "block/greyscale/rock/ore_bearing/vanilla/" + ore_overlay);
                }
                case BlockCategoryFlags.ENGINEERING_BLOCK, BlockCategoryFlags.ADVANCED_ENGINEERING_BLOCK, BlockCategoryFlags.STAIRS, BlockCategoryFlags.SLAB, BlockCategoryFlags.FENCE -> new ResourceLocation("immersivegeology", "block/greyscale/metal/storage");
                case BlockCategoryFlags.EVAPORATE -> new ResourceLocation("immersivegeology", "block/greyscale/evaporate/type_1");
                case BlockCategoryFlags.SHEETMETAL_BLOCK, BlockCategoryFlags.SHEETMETAL_SLAB, BlockCategoryFlags.SHEETMETAL_STAIRS -> new ResourceLocation("immersivegeology", "block/greyscale/metal/sheetmetal");
                case BlockCategoryFlags.DUST_BLOCK -> new ResourceLocation("immersivegeology", "block/greyscale/metal/dust_block");
                case BlockCategoryFlags.GEODE_BLOCK -> new ResourceLocation("immersivegeology", "block/greyscale/stone/geode");
                default -> new ResourceLocation("immersivegeology", "block/greyscale/stone/cobble");
            };
        }
        ore_overlay = pattern.getValue();
        if (ore_overlay instanceof ItemCategoryFlags) {
            ItemCategoryFlags i = (ItemCategoryFlags)ore_overlay;
            switch (i) {
                case CLAY: {
                    return new ResourceLocation("immersivegeology", "item/greyscale/rock/" + i.getName());
                }
                case GEAR: 
                case INGOT: 
                case NUGGET: 
                case PLATE: 
                case SLAG: 
                case COMPOUND_DUST: 
                case TOOL_HOE: 
                case CRUSHED_ORE: {
                    return new ResourceLocation("immersivegeology", "palette/item/" + i.getName() + "/type_" + this.getPaletteVariation(i) + "_pristine_" + this.getName().toLowerCase());
                }
                case POOR_ORE: 
                case NORMAL_ORE: 
                case RICH_ORE: 
                case GRIT: 
                case POWDER: 
                case POWDERED_SLAG: 
                case DIRTY_CRUSHED_ORE: {
                    String weathering = this.canTarnish() ? "corroded" : "pristine";
                    return new ResourceLocation("immersivegeology", "palette/item/" + i.getName() + "/type_" + this.getPaletteVariation(i) + "_" + weathering + "_" + this.getName().toLowerCase());
                }
                case METAL_OXIDE: {
                    return new ResourceLocation("immersivegeology", "palette/item/" + i.getName() + "/type_" + this.getPaletteVariation(i) + "_corroded_" + this.getName().toLowerCase());
                }
                case DRILL_HEAD: {
                    return new ResourceLocation("immersivegeology", "palette/item/" + i.getName() + "/drill_pristine_" + this.getName().toLowerCase());
                }
                case ROD: 
                case WIRE: {
                    return new ResourceLocation("immersivegeology", "item/greyscale/metal/" + i.getName());
                }
                case CRYSTAL: {
                    return new ResourceLocation("immersivegeology", "item/greyscale/crystal/" + this.getCrystalFamily().getName());
                }
            }
            return new ResourceLocation("immersivegeology", "item/greyscale/" + i.getName());
        }
        return null;
    }

    public int getPaletteVariation(ItemCategoryFlags flag) {
        rand.setSeed(IGLib.fastHash(this.getName()));
        return 1 + rand.nextInt(flag.getVariations()) % flag.getVariations();
    }

    public int getPaletteVariation(BlockCategoryFlags flag) {
        rand.setSeed(IGLib.fastHash(this.getName()));
        return 1 + rand.nextInt(flag.getVariations()) % flag.getVariations();
    }

    @Override
    public boolean acceptableStoneType(MaterialStone stone) {
        return this.acceptableStoneTypes.contains((Object)stone.getStoneFormation());
    }

    public boolean isValidStoneFormation(StoneFormation formation) {
        return this.acceptableStoneTypes.contains((Object)formation);
    }

    public Set<StoneFormation> getValidStoneFormations() {
        return this.acceptableStoneTypes;
    }

    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.CUBIC;
    }

    public FluidType.Properties getFluidProperties(IFlagType<?> flag) {
        return FluidType.Properties.create().temperature(this.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? 2000 : (this.hasFlag(MaterialFlags.IS_CHEMICAL) ? 600 : 0)).canSwim(true).canDrown(false).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).viscosity(100).density(this.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? 3000 : (this.hasFlag(MaterialFlags.IS_GAS) ? -100 : 1000)).canPushEntity(true).motionScale(this.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? (double)0.025f : (double)0.05f).fallDistanceModifier(0.25f).descriptionId("fluid.immersivegeology." + flag.getName().toLowerCase());
    }

    public static Consumer<FluidType.Properties> createBuildAttributes(int density, int viscosity, String name) {
        return builder -> builder.descriptionId(name).density(density).viscosity(viscosity);
    }

    public Map<ModFlags, Map<IFlagType<?>, MaterialHelper>> getExistingImplementationMap() {
        return this.EXISTING_IMPLEMENTATION_MAP;
    }

    @Override
    public boolean checkExistingImplementation(IFlagType<?> h) {
        for (ModFlags m : ModFlags.values()) {
            if (!m.isStrictlyLoaded() || !this.EXISTING_IMPLEMENTATION_MAP.containsKey(m) || !this.EXISTING_IMPLEMENTATION_MAP.get(m).containsKey(h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean weakCheckExistingImplementation(IFlagType<?> h) {
        for (ModFlags m : ModFlags.values()) {
            if (!this.EXISTING_IMPLEMENTATION_MAP.containsKey(m) || !this.EXISTING_IMPLEMENTATION_MAP.get(m).containsKey(h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkExistingImplementation(ModFlags m, IFlagType<?> h) {
        return m.isStrictlyLoaded() && this.EXISTING_IMPLEMENTATION_MAP.containsKey(m) && this.EXISTING_IMPLEMENTATION_MAP.get(m).containsKey(h);
    }

    public boolean hasExistingFlag(IFlagType<?> h) {
        return this.EXISTING_IMPLEMENTATION_MAP.entrySet().stream().anyMatch(e -> ((Map)e.getValue()).containsKey(h));
    }

    @Override
    public void addExistingFlag(ModFlags m, ItemCategoryFlags ... f) {
        if (this.EXISTING_IMPLEMENTATION_MAP.containsKey(m)) {
            for (ItemCategoryFlags flag : f) {
                this.EXISTING_IMPLEMENTATION_MAP.get(m).put(flag, this);
            }
            return;
        }
        HashMap<ItemCategoryFlags, GeologyMaterial> map = new HashMap<ItemCategoryFlags, GeologyMaterial>();
        for (ItemCategoryFlags flag : f) {
            map.put(flag, this);
        }
        this.EXISTING_IMPLEMENTATION_MAP.put(m, map);
    }

    @Override
    public void addExistingFlag(ModFlags m, BlockCategoryFlags ... f) {
        if (this.EXISTING_IMPLEMENTATION_MAP.containsKey(m)) {
            for (BlockCategoryFlags flag : f) {
                this.EXISTING_IMPLEMENTATION_MAP.get(m).put(flag, this);
            }
            return;
        }
        HashMap<BlockCategoryFlags, GeologyMaterial> map = new HashMap<BlockCategoryFlags, GeologyMaterial>();
        for (BlockCategoryFlags flag : f) {
            map.put(flag, this);
        }
        this.EXISTING_IMPLEMENTATION_MAP.put(m, map);
    }

    public TagKey<Fluid> getFluidTag() {
        return this.getFluidTag(BlockCategoryFlags.FLUID);
    }

    public TagKey<Fluid> getFluidTag(BlockCategoryFlags flag) {
        HashMap data_map = IGTags.FLUID_TAG_HOLDER.get(flag);
        LinkedHashSet<MaterialHelper> material_set = new LinkedHashSet<MaterialHelper>(Collections.singletonList(this));
        String key = IGTags.getWrapFromSet(material_set);
        return (TagKey)data_map.get(key);
    }

    @Nullable
    public TagKey<Fluid> getFluidTag(BlockCategoryFlags flag, MaterialInterface<?> ... materials) {
        if (!IGTags.isInitialized()) {
            throw new RuntimeException("Called getFluidTag before Tags have been Initialized");
        }
        Set helpers = Arrays.stream(materials).map(MaterialInterface::instance).collect(Collectors.toSet());
        return this.getFluidTag(flag, (MaterialHelper[])helpers.toArray(MaterialHelper[]::new));
    }

    @Override
    @Nullable
    public TagKey<Fluid> getFluidTag(BlockCategoryFlags flag, MaterialHelper ... materials) {
        if (!IGTags.isInitialized()) {
            throw new IllegalStateException("Called getFluidTag before Tags have been initialized");
        }
        HashSet<MaterialHelper> helpers = new HashSet<MaterialHelper>(Arrays.asList(materials));
        Map fluidTagMap = IGTags.FLUID_TAG_HOLDER.get(flag);
        LinkedHashSet<MaterialHelper> materialSet = new LinkedHashSet<MaterialHelper>();
        materialSet.add(this);
        materialSet.addAll(helpers);
        String key = IGTags.getWrapFromSet(flag, materialSet);
        if (!fluidTagMap.containsKey(key)) {
            IGTags.initialize();
            boolean initializationSuccessful = fluidTagMap.containsKey(key);
            if (!initializationSuccessful) {
                String materialNames = materialSet.stream().map(MaterialHelper::getName).collect(Collectors.joining(", "));
                String errorMsg = String.format("Failed to initialize Fluid Tags: %s %s", flag.name(), materialNames);
                throw new IllegalStateException(errorMsg);
            }
        }
        return (TagKey)fluidTagMap.get(key);
    }

    @Override
    public Set<IGRecipeStage> getMaterialStageSet() {
        return this.stage_set;
    }

    @Override
    public void addStage(IGRecipeStage stage) {
        this.stage_set.add(stage);
    }

    @Override
    public MaterialInterface<?> getPrimaryProduct() {
        LinkedHashSet<MaterialInterface<?>> set = this.getDerivedMaterials();
        if (set.isEmpty()) {
            IGLib.IG_LOGGER.warn("Called a Primary Use (product) Source Material with no Entry [{}]", (Object)this.getName());
            return MetalEnum.Unobtanium;
        }
        List list = set.stream().toList();
        return (MaterialInterface)list.get(0);
    }

    @Override
    public MaterialInterface<?> getSecondaryProduct() {
        LinkedHashSet<MaterialInterface<?>> set = this.getDerivedMaterials();
        if (set.size() < 2) {
            IGLib.IG_LOGGER.error("Called a Secondary Source (Byproduct) Material with no Entry [{}]", (Object)this.getName());
            return MetalEnum.Unobtanium;
        }
        List list = set.stream().toList();
        return (MaterialInterface)list.get(1);
    }

    @Override
    public MaterialInterface<?> getTraceProduct(int index) {
        LinkedHashSet<MaterialInterface<?>> set = this.getDerivedMaterials();
        if (set.size() < index + 1) {
            IGLib.IG_LOGGER.error("Called a Trace Material with no Entry [{}]", (Object)this.getName());
            return MetalEnum.Unobtanium;
        }
        List list = set.stream().toList();
        return (MaterialInterface)list.get(index);
    }

    public void setAsocialMaterialChance(float chance) {
        this.asocialMaterialChance = chance;
    }

    public float getAssociateMaterialChance() {
        return this.asocialMaterialChance;
    }

    public void addGenerationFriend(Function<Integer, MaterialHelper> material, int chance) {
        this.generation_group.add((Pair<Function<Integer, MaterialHelper>, Integer>)Pair.of(material, (Object)chance));
    }

    public Set<Pair<Function<Integer, MaterialHelper>, Integer>> getAssociateMaterialSet() {
        return this.generation_group;
    }

    public void setBurntime(int burntime) {
        this.burntime = burntime;
    }

    public int getBurntime() {
        return this.burntime;
    }

    public boolean canBurn() {
        return this.burntime > 0;
    }

    public float getNoiseProbability() {
        return 0.0f;
    }

    public void fluidTick(Level level, BlockPos pos, FluidState state) {
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.hasFlag(MaterialFlags.IS_MOLTEN_METAL) && !entity.m_5825_()) {
            entity.m_20254_(2);
        }
    }

    public boolean fluidSpreadEvent(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        return false;
    }

    public boolean canFormMB(MultiblockHandler.IMultiblock multiblock) {
        return this.validMultiblocks.stream().anyMatch(s -> ((MultiblockHandler.IMultiblock)s.get()).equals(multiblock));
    }

    public TagKey<Item> getItemMaterialTag() {
        return IGTags.ITEM_MATERIAL_HOLDER.get(this);
    }

    public TagKey<Block> getBlockMaterialTag() {
        return IGTags.BLOCK_MATERIAL_HOLDER.get(this);
    }

    public ItemStack getOreIcon() {
        if (this.acceptableStoneType(StoneEnum.MCStone)) {
            return new ItemStack((ItemLike)this.getOreBlock(StoneEnum.MCStone, OreRichness.NORMAL).asIGItem());
        }
        if (this.acceptableStoneType(StoneEnum.MCNetherrack)) {
            return new ItemStack((ItemLike)this.getOreBlock(StoneEnum.MCNetherrack, OreRichness.NORMAL).asIGItem());
        }
        if (this.acceptableStoneType(StoneEnum.MCEndStone)) {
            return new ItemStack((ItemLike)this.getOreBlock(StoneEnum.MCEndStone, OreRichness.NORMAL).asIGItem());
        }
        return ItemStack.f_41583_;
    }

    public List<String> getAcceptableDimensions() {
        return List.of("minecraft:overworld");
    }

    static {
        rand = new Random(0L);
    }
}

