/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.enums;

import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.common.world.features.IGOreFeature;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialAcanthite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialAlumina;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialAnatase;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialAnthracite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialApatite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialBauxite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialBituminous;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialCarnallite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialCassiterite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialChalcocite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialChalcopyrite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialChromite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialCobaltite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialCryolite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialCuprite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialFluorite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialGalena;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialGypsum;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialHematite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialIlmenite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialLignite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialMagnetite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialMillerite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialMolybdenite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialMonazite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialPyrite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialPyrolusite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialRocksalt;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialSaltpeter;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialScheelite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialSmithsonite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialSphalerite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialThorianite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialThorite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialUnobtania;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialUraninite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialVanadinite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialWolframite;
import com.igteam.immersivegeology.core.material.data.mineral.MaterialZircon;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public enum MineralEnum implements MaterialInterface<MaterialMineral>,
IWorldGenConfig
{
    Acanthite(new MaterialAcanthite()),
    Apatite(new MaterialApatite()),
    Alumina(new MaterialAlumina()),
    Anatase(new MaterialAnatase()),
    Bauxite(new MaterialBauxite()),
    Bituminous(new MaterialBituminous()),
    Anthracite(new MaterialAnthracite()),
    Cassiterite(new MaterialCassiterite()),
    Carnallite(new MaterialCarnallite()),
    Chalcocite(new MaterialChalcocite()),
    Chalcopyrite(new MaterialChalcopyrite()),
    Chromite(new MaterialChromite()),
    Cobaltite(new MaterialCobaltite()),
    Cryolite(new MaterialCryolite()),
    Cuprite(new MaterialCuprite()),
    Fluorite(new MaterialFluorite()),
    Galena(new MaterialGalena()),
    Gypsum(new MaterialGypsum()),
    Hematite(new MaterialHematite()),
    Ilmenite(new MaterialIlmenite()),
    Lignite(new MaterialLignite()),
    Magnetite(new MaterialMagnetite()),
    Molybdenite(new MaterialMolybdenite()),
    Monazite(new MaterialMonazite()),
    Pyrite(new MaterialPyrite()),
    Pyrolusite(new MaterialPyrolusite()),
    Saltpeter(new MaterialSaltpeter()),
    Scheelite(new MaterialScheelite()),
    Smithsonite(new MaterialSmithsonite()),
    Sphalerite(new MaterialSphalerite()),
    Rocksalt(new MaterialRocksalt()),
    Thorianite(new MaterialThorianite()),
    Thorite(new MaterialThorite()),
    Millerite(new MaterialMillerite()),
    Unobtania(new MaterialUnobtania()),
    Uraninite(new MaterialUraninite()),
    Vanadinite(new MaterialVanadinite()),
    Wolframite(new MaterialWolframite()),
    Zircon(new MaterialZircon());

    private final MaterialMineral material;

    private MineralEnum(MaterialMineral m) {
        this.material = m;
    }

    public static List<String> getAtlasPermutations() {
        ArrayList<String> permutations = new ArrayList<String>();
        Arrays.stream(MineralEnum.values()).forEach(e -> {
            for (MineralWeathering weathering : MineralWeathering.values()) {
                permutations.add(e.getName() + "/" + weathering.name().toLowerCase());
            }
        });
        return permutations;
    }

    @Override
    public MaterialMineral instance() {
        return this.material;
    }

    @Override
    public String getName() {
        return this.material.getName();
    }

    @Override
    public IOreBlock getOreBlock(StoneEnum stone, OreRichness richness) {
        if (this.material.getOreBlock(stone, richness) == null) {
            return this.material.getOreBlock(StoneEnum.MCStone, richness);
        }
        return this.material.getOreBlock(stone, richness);
    }

    @Override
    public BlockState getDefaultBlockstate() {
        return this.material.getBlock(BlockCategoryFlags.EVAPORATE).m_49966_();
    }

    @Override
    public IOreBlock getOreBlock(MaterialHelper stone, OreRichness richness) {
        if (this.material.getOreBlock(stone, richness) == null) {
            return this.material.getOreBlock(StoneEnum.MCStone, richness);
        }
        return this.material.getOreBlock(stone, richness);
    }

    @Override
    public int getVeinSize() {
        return this.material.CONFIG.veinSize();
    }

    @Override
    public int getMinY() {
        return this.material.CONFIG.minY();
    }

    @Override
    public int getMaxY() {
        return this.material.CONFIG.maxY();
    }

    @Override
    public int veinsPerChunk() {
        return this.material.CONFIG.veinsPerChunk();
    }

    @Override
    public int rarity() {
        return this.material.CONFIG.rarity();
    }

    @Override
    public int generationChance() {
        return this.material.CONFIG.generationChance();
    }

    @Override
    public double density() {
        return this.material.CONFIG.density();
    }

    @Override
    public boolean useSparsePlacement() {
        return this.material.CONFIG.useSparsePlacement();
    }

    @Override
    public Optional<TagKey<Biome>> getPreferredBiome() {
        return this.material.CONFIG.preferredBiome();
    }

    @Override
    public IGGenerationType getGenerationType() {
        return this.material.CONFIG.generationType();
    }

    @Override
    public double getAssociateMaterialChance() {
        return this.instance().getAssociateMaterialChance();
    }

    @Override
    public Set<Pair<Function<Integer, MaterialHelper>, Integer>> getAssociateMaterialSet() {
        return this.instance().getAssociateMaterialSet();
    }

    @Override
    public double getMinSpawnTemp() {
        return -1.0;
    }

    @Override
    public double getMaxSpawnTemp() {
        return 2.0;
    }

    @Override
    public double getMinDownfall() {
        return 0.0;
    }

    @Override
    public double getMaxDownfall() {
        return 1.0;
    }

    @Override
    public long seed() {
        return IGOreFeature.IGOreFeatureConfig.hash(this.name());
    }

    @Override
    public IWorldGenConfig getConfig() {
        return this;
    }
}

