/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.metal;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialNativeMetal;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialColorHelper;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;

public class MaterialCopper
extends MaterialNativeMetal {
    Function<Integer, Integer> coloredWeathering = MaterialColorHelper.setupWeatheredColors(List.of(MaterialColorHelper.weatheredColor(MineralWeathering.PRISTINE, -4821443), MaterialColorHelper.weatheredColor(MineralWeathering.TARNISHED, -12743797)));

    public MaterialCopper() {
        this.addFlags(MaterialFlags.EXISTING_IMPLEMENTATION, ItemCategoryFlags.OXIDE_PELLET);
        this.addExistingFlag(ModFlags.MINECRAFT, ItemCategoryFlags.INGOT);
        this.addExistingFlag(ModFlags.MINECRAFT, BlockCategoryFlags.STORAGE_BLOCK);
        this.addExistingFlag(ModFlags.IMMERSIVEENGINEERING, BlockCategoryFlags.SHEETMETAL_BLOCK, BlockCategoryFlags.STAIRS, BlockCategoryFlags.SLAB);
        this.addExistingFlag(ModFlags.IMMERSIVEENGINEERING, ItemCategoryFlags.WIRE, ItemCategoryFlags.POWDER, ItemCategoryFlags.PLATE, ItemCategoryFlags.NUGGET);
        this.addExistingFlag(ModFlags.TFC, BlockCategoryFlags.ORE_BLOCK);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.CONFIG = new MaterialMineral.MineralConfig(10, 70, 1, 0, 128, 2000, 0.5, true, Optional.of(BiomeTags.f_215817_), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> this.coloredWeathering.apply((Integer)i);
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.bloomery(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, 2, this, ItemCategoryFlags.INGOT, 1, 200);
        IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
        IGMethodBuilder.chemical(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, BlockCategoryFlags.SLURRY, ItemStack.f_41583_, ChemicalEnum.HydrochloricAcid.getSlurryWith(MetalEnum.Copper, 216), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.CRUSHED_ORE, 1)), new FluidTagInput(ChemicalEnum.HydrochloricAcid.getFluidTag(BlockCategoryFlags.FLUID), 250), null, null, 200, 51200);
        IGMethodBuilder.crystallize(this, IGStageDesignation.CRYSTALLIZATION).create(ChemicalEnum.HydrochloricAcid, ItemCategoryFlags.CRYSTAL);
        IGMethodBuilder.basicSmelting(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.INGOT, 120);
    }

    @Override
    public boolean canTarnish() {
        return true;
    }

    @Override
    public float getNoiseProbability() {
        return 0.047180176f;
    }
}

