/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.metal;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMetal;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;

public class MaterialTungsten
extends MaterialMetal {
    public MaterialTungsten() {
        this.addFlags(ItemCategoryFlags.OXIDE_PELLET, BlockCategoryFlags.SCAFFOLDING, BlockCategoryFlags.FENCE, BlockCategoryFlags.ENGINEERING_BLOCK);
        this.removeMaterialFlags(ItemCategoryFlags.SLAG, ItemCategoryFlags.CRYSTAL);
        this.addFlags(ItemCategoryFlags.POWDER, ItemCategoryFlags.MECHANICAL_COMPONENT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -12300950;
    }

    @Override
    public boolean useColumnBlockStyle(IFlagType<?> flag) {
        return flag.equals(BlockCategoryFlags.STORAGE_BLOCK);
    }

    @Override
    public void setupRecipeStages() {
        IGMethodBuilder.crushing(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.INGOT, ItemCategoryFlags.GRIT, 6000, 100);
        IGMethodBuilder.pulverization(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 6000, 51200);
        IGMethodBuilder.pelletize(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.METAL_OXIDE, ItemCategoryFlags.OXIDE_PELLET);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("pellet_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.OXIDE_PELLET), this.getPrimaryProduct().getStack(ItemCategoryFlags.INGOT), 1800);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(this.getName() + "slurry_to_compound_dust", this.getStack(ItemCategoryFlags.COMPOUND_DUST, 1), ChemicalEnum.ChemicalWaste.getFluidStack(120), IngredientWithSize.of((ItemStack)ItemStack.f_41583_), new FluidTagInput(ChemicalEnum.HydrochloricAcid.getSlurryTagWith(MetalEnum.Tungsten), 144), new FluidTagInput(ChemicalEnum.Ammonia.getFluidTag(BlockCategoryFlags.FLUID), 144), null, 200, 51200);
        IGMethodBuilder.decompose(this, IGStageDesignation.EXTRACTION).create(ItemCategoryFlags.METAL_OXIDE, ItemCategoryFlags.COMPOUND_DUST, 1, 300).setMVHeat();
    }
}

