/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraftforge.common.Tags;

public class MaterialApatite
extends MaterialSulphideMineral {
    protected IGRecipeChain acid_production = new IGRecipeChain(this, "Phosphoric Acid Production", 0);

    public MaterialApatite() {
        this.acceptableStoneTypes.remove((Object)StoneFormation.NETHER_STONE);
        this.acceptableStoneTypes.add(StoneFormation.METAMORPHIC);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.CONFIG = new MaterialMineral.MineralConfig(24, 30, 1, -64, 212, 600, 0.85, false, Optional.of(Tags.Biomes.IS_COLD), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -7876885;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.HEXAGONAL;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        LinkedHashSet materials = new LinkedHashSet();
        materials.add(MetalEnum.Calcium);
        return materials;
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGRecipeNode prep = IGMethodBuilder.crushing(this, IGStageDesignation.EXTRACTION).create("crushed_ore" + this.getName() + "_to_dust", this.getStack(ItemCategoryFlags.CRUSHED_ORE, 1), this.getStack(ItemCategoryFlags.GRIT, 1), 10000, 100).addToTree(this.acid_production);
        IGRecipeNode grit = IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100).addToTree(this.acid_production, prep);
        IGRecipeNode powder_b = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POWDER).addToTree(this.acid_production, prep);
        IGRecipeNode powder_a = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 200, 16000).addToTree(this.acid_production, grit);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create("apatite_dust_to_acid", MetalEnum.Calcium.getStack(ItemCategoryFlags.COMPOUND_DUST), ChemicalEnum.PhosphoricAcid.getFluidStack(120), new IngredientWithSize(this.getItemTag(ItemCategoryFlags.POWDER), 1), new FluidTagInput(ChemicalEnum.SulfuricAcid.getFluidTag(BlockCategoryFlags.FLUID), 125), null, null, 200, 51200).joinBranches(this.acid_production, powder_a, powder_b);
    }

    @Override
    public float getNoiseProbability() {
        return 0.30493164f;
    }
}

