/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;

public class MaterialChromite
extends MaterialMineral {
    public MaterialChromite() {
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.METAMORPHIC);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.CONFIG = new MaterialMineral.MineralConfig(30, 45, 1, -64, 24, 1350, 0.5, false, Optional.of(Tags.Biomes.IS_COLD), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -10397340;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Chromium, MetalEnum.Iron));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 200, 16000);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POWDER);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("separate_oxides_from_" + this.getName(), this.getItemTag(ItemCategoryFlags.POWDER), 1, MetalEnum.Chromium.getStack(ItemCategoryFlags.COMPOUND_DUST), ItemStack.f_41583_, new IngredientWithSize(IETags.coalCokeDust, 1), new IngredientWithSize(MetalEnum.Sodium.getItemTag(ItemCategoryFlags.COMPOUND_DUST), 1)).addExtras(MetalEnum.Iron.getItemTag(ItemCategoryFlags.INGOT), Float.valueOf(0.8f)).setTimeAndEnergy(400, 204800);
    }

    @Override
    public float getNoiseProbability() {
        return 0.105895996f;
    }
}

