/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MaterialCobaltite
extends MaterialSulphideMineral {
    public MaterialCobaltite() {
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.METAMORPHIC);
        this.removeMaterialFlags(ItemCategoryFlags.GRIT);
        this.removeMaterialFlags(ItemCategoryFlags.POWDER);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(21, 60, 1, -64, 72, 1200, 0.5, false, Optional.of(BiomeTags.f_207612_), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -7103804;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.ORTHORHOMBIC;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Cobalt, MetalEnum.Platinum, MetalEnum.Osmium));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.roast(this, IGStageDesignation.PREPARATION).create("crushed_ore_" + this.getName() + "_to_slag", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), 1, this.getStack(ItemCategoryFlags.SLAG, 1), 800, 25).addToTree(this.sulphideElectrowining);
        IGRecipeNode powdered_slag = IGMethodBuilder.pulverization(this, IGStageDesignation.EXTRACTION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), this.getPrimaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), new ItemStack((ItemLike)Items.f_41830_), 0.075f, 200, 250).addToTree(this.sulphideElectrowining, powdered_slag);
        IGRecipeNode slurry = IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(ItemCategoryFlags.POWDERED_SLAG, BlockCategoryFlags.SLURRY, MetalEnum.Osmium.getStack(ItemCategoryFlags.COMPOUND_DUST, 1), ChemicalEnum.NitricAcid.getSlurryWith(MetalEnum.Cobalt, 648), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.POWDERED_SLAG, 3)), new FluidTagInput(ChemicalEnum.NitricAcid.getFluidTag(BlockCategoryFlags.FLUID), 750), null, null, 200, 51200).addToTree(this.sulphideElectrowining, powdered_slag);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.sulphideElectrowining);
    }

    @Override
    public float getNoiseProbability() {
        return 0.11743164f;
    }
}

