/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;

public class MaterialGalena
extends MaterialSulphideMineral {
    public MaterialGalena() {
        this.acceptableStoneTypes.add(StoneFormation.METAMORPHIC);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.PELLET);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(32, 45, 2, -64, 128, 1250, 0.5, false, Optional.of(BiomeTags.f_207612_), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -8028285;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Lead, MetalEnum.Silver, MetalEnum.Platinum, MetalEnum.Osmium));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.roast(this, IGStageDesignation.ROASTING).create(ItemCategoryFlags.CRUSHED_ORE, 1, ItemCategoryFlags.SLAG, 1, 1000, 25).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("crushed_ore_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), MetalEnum.Lead.getStack(ItemCategoryFlags.INGOT), 900);
        IGRecipeNode powdered_slag = IGMethodBuilder.pulverization(this, IGStageDesignation.EXTRACTION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), this.getPrimaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), this.getSecondaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), 0.075f, 200, 250).addToTree(this.sulphideElectrowining, powdered_slag);
        IGRecipeNode slurry = IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(ItemCategoryFlags.POWDERED_SLAG, BlockCategoryFlags.SLURRY, MetalEnum.Osmium.getStack(ItemCategoryFlags.COMPOUND_DUST, 1), ChemicalEnum.HydrochloricAcid.getSlurryWith(MineralEnum.Galena, 648), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.POWDERED_SLAG, 3)), new FluidTagInput(ChemicalEnum.HydrochloricAcid.getFluidTag(BlockCategoryFlags.FLUID), 750), null, null, 200, 51200).addToTree(this.sulphideElectrowining, powdered_slag);
        IGMethodBuilder.crystallize(this, IGStageDesignation.CRYSTALLIZATION).create("mineral_slurry_" + this.getName() + "_to_" + this.getSecondaryProduct().getName() + "_crystal", MetalEnum.Silver.getStack(ItemCategoryFlags.CRYSTAL, 1), ChemicalEnum.HydrochloricAcid.getSlurryWith(MetalEnum.Lead, 240), ChemicalEnum.HydrochloricAcid.getSlurryTagWith(MineralEnum.Galena), 288, 300, 38400).addToTree(this.sulphideElectrowining, slurry);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.directBlasting, this.sulphideElectrowining);
    }

    @Override
    public float getNoiseProbability() {
        return 0.49456787f;
    }

    @Override
    public List<String> getAcceptableDimensions() {
        return List.of("minecraft:overworld", "minecraft:the_nether");
    }
}

