/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraftforge.common.Tags;

public class MaterialIlmenite
extends MaterialMineral {
    protected IGRecipeChain becher_process = new IGRecipeChain(this, "Becher process", 0);

    public MaterialIlmenite() {
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_EXTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.removeMaterialFlags(ItemCategoryFlags.GRIT);
        this.removeMaterialFlags(ItemCategoryFlags.POWDER);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(33, 40, 2, 5, 140, 2000, 0.5, false, Optional.of(Tags.Biomes.IS_MOUNTAIN), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -11911618;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.HEXAGONAL;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Iron, MetalEnum.Titanium));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.decompose(this, IGStageDesignation.PURIFICATION).create("crushed_ore_" + this.getName() + "_to_slag", this.getStack(ItemCategoryFlags.SLAG, 1), this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), 1, 300).setHVHeat().addToTree(this.becher_process);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PURIFICATION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.becher_process);
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), this.getPrimaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), this.getSecondaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), 0.5f, 300, 250).addToTree(this.becher_process);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.becher_process);
    }

    @Override
    public float getNoiseProbability() {
        return 0.08856201f;
    }
}

