/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialColorHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.tags.BiomeTags;

public class MaterialMagnetite
extends MaterialMineral {
    Function<Integer, Integer> coloredWeathering = MaterialColorHelper.setupWeatheredColors(List.of(MaterialColorHelper.weatheredColor(MineralWeathering.PRISTINE, 0x2A2A2A), MaterialColorHelper.weatheredColor(MineralWeathering.TARNISHED, 10246707)));

    public MaterialMagnetite() {
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.addFlags(ModFlags.TFC, MaterialFlags.EXISTING_IMPLEMENTATION);
        this.addFlags(ItemCategoryFlags.PELLET);
        this.addExistingFlag(ModFlags.TFC, BlockCategoryFlags.ORE_BLOCK);
        this.CONFIG = new MaterialMineral.MineralConfig(43, 35, 1, -64, 320, 1150, 0.6, false, Optional.of(BiomeTags.f_215817_), IGGenerationType.BANDED);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> this.coloredWeathering.apply((Integer)i);
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Iron, MetalEnum.Nickel));
    }

    @Override
    public boolean canTarnish() {
        return true;
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.bloomery(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, 4, ItemCategoryFlags.INGOT, 1, 1200);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("crushed_ore_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), this.getPrimaryProduct().getStack(ItemCategoryFlags.INGOT), 900);
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDER), MetalEnum.Iron.getStack(ItemCategoryFlags.METAL_OXIDE), MetalEnum.Nickel.getStack(ItemCategoryFlags.METAL_OXIDE), 0.075f, 200, 250);
    }

    @Override
    public float getNoiseProbability() {
        return 0.97540283f;
    }
}

