/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;

public class MaterialMolybdenite
extends MaterialSulphideMineral {
    public MaterialMolybdenite() {
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.METAMORPHIC);
        this.removeMaterialFlags(ItemCategoryFlags.GRIT);
        this.removeMaterialFlags(ItemCategoryFlags.POWDER);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(12, 70, 1, -64, 212, 1000, 0.75, false, Optional.of(BiomeTags.f_207612_), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -4994076;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.HEXAGONAL;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Molybdenum, MetalEnum.Osmium, MetalEnum.Platinum));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.roast(this, IGStageDesignation.ROASTING).create(ItemCategoryFlags.CRUSHED_ORE, 1, ItemCategoryFlags.SLAG, 1, 1000, 25).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.pulverization(this, IGStageDesignation.EXTRACTION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(this.getName() + "ore_to_slurry", MetalEnum.Osmium.getStack(ItemCategoryFlags.COMPOUND_DUST, 1), ChemicalEnum.Ammonia.getCloudySlurryWith(MineralEnum.Molybdenite, 648), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.POWDERED_SLAG, 1)), new FluidTagInput(ChemicalEnum.Ammonia.getFluidTag(BlockCategoryFlags.FLUID), 750), null, null, 200, 51200).addToTree(this.sulphideElectrowining);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.sulphideElectrowining);
    }

    @Override
    public float getNoiseProbability() {
        return 0.05895996f;
    }
}

