/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.client.helper.IGVeinTextureType;
import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialColorHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;

public class MaterialPyrite
extends MaterialSulphideMineral {
    Function<Integer, Integer> coloredWeathering = MaterialColorHelper.setupWeatheredColors(List.of(MaterialColorHelper.weatheredColor(MineralWeathering.PRISTINE, -10496), MaterialColorHelper.weatheredColor(MineralWeathering.TARNISHED, -7640259)));

    public MaterialPyrite() {
        this.acceptableStoneTypes.add(StoneFormation.METAMORPHIC);
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.setAsocialMaterialChance(1.0f);
        this.addGenerationFriend(h -> MineralEnum.Chalcopyrite.instance(), 50);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.PELLET);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(12, 30, 3, -64, 112, 2000, 0.5, false, Optional.of(BiomeTags.f_207612_), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> this.coloredWeathering.apply((Integer)i);
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Iron, MetalEnum.Molybdenum, MetalEnum.Osmium, MetalEnum.Platinum));
    }

    @Override
    public boolean canTarnish() {
        return true;
    }

    @Override
    public IGVeinTextureType getVeinTextureType() {
        return IGVeinTextureType.CRYSTAL;
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.roast(this, IGStageDesignation.PREPARATION).create("crushed_ore_" + this.getName() + "_to_oxide", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), 1, this.getStack(ItemCategoryFlags.SLAG, 1), 800, 25).addToTree(this.sulphideElectrowining);
        IGRecipeNode powdered_slag = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), this.getPrimaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), this.getSecondaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), 0.075f, 200, 250).addToTree(this.sulphideElectrowining, powdered_slag);
        IGRecipeNode slurry = IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(ItemCategoryFlags.POWDERED_SLAG, BlockCategoryFlags.SLURRY, MetalEnum.Osmium.getStack(ItemCategoryFlags.COMPOUND_DUST, 1), ChemicalEnum.SulfuricAcid.getSlurryWith(MineralEnum.Pyrite, 648), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.POWDERED_SLAG, 3)), new FluidTagInput(ChemicalEnum.SulfuricAcid.getFluidTag(BlockCategoryFlags.FLUID), 750), null, null, 200, 51200).addToTree(this.sulphideElectrowining, powdered_slag);
        IGMethodBuilder.crystallize(this, IGStageDesignation.CRYSTALLIZATION).create("mineral_slurry_" + this.getName() + "_to_" + this.getSecondaryProduct().getName() + "_crystal", MetalEnum.Molybdenum.getStack(ItemCategoryFlags.CRYSTAL, 1), ChemicalEnum.SulfuricAcid.getSlurryWith(MetalEnum.Iron, 240), ChemicalEnum.SulfuricAcid.getSlurryTagWith(MineralEnum.Pyrite), 288, 300, 38400).addToTree(this.sulphideElectrowining, slurry);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.directBlasting, this.sulphideElectrowining);
    }

    @Override
    public float getNoiseProbability() {
        return 0.089660645f;
    }
}

