/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.common.register.IEItems;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class MaterialSmithsonite
extends MaterialMineral {
    public MaterialSmithsonite() {
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.PELLET);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(33, 50, 2, 30, 70, 550, 0.5, false, Optional.of(Tags.Biomes.IS_WET), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -8269348;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.HEXAGONAL;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Zinc, MetalEnum.Copper));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGRecipeNode slag = IGMethodBuilder.decompose(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.CRUSHED_ORE, 1, 300).setLVHeat().addOptionalToTree(this.directBlasting);
        IGRecipeNode p_slag = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.directBlasting, slag);
        IGMethodBuilder.separating(this, IGStageDesignation.PREPARATION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), MetalEnum.Zinc.getStack(ItemCategoryFlags.METAL_OXIDE), MetalEnum.Copper.getStack(ItemCategoryFlags.METAL_OXIDE), 0.075f, 200, 250).addToTree(this.directBlasting, p_slag);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create(this, ItemCategoryFlags.SLAG, (MaterialHelper)this.getPrimaryProduct().instance(), ItemCategoryFlags.INGOT, new ItemStack((ItemLike)IEItems.Ingredients.SLAG), 900).addToTree(this.directBlasting, slag);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("crushed_ore_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), this.getPrimaryProduct().getStack(ItemCategoryFlags.NUGGET, 5)).addOptionalToTree(this.directBlasting);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.directBlasting);
    }

    @Override
    public float getNoiseProbability() {
        return 0.14581299f;
    }
}

