/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.misc;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.igteam.immersivegeology.core.material.data.types.MaterialMisc;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class MaterialRuined
extends MaterialMisc {
    public MaterialRuined() {
        this.name = "rusty_metal";
        this.addFlags(BlockCategoryFlags.STORAGE_BLOCK, BlockCategoryFlags.DEFAULT_BLOCK, BlockCategoryFlags.SLAB, BlockCategoryFlags.STAIRS, BlockCategoryFlags.SHEETMETAL_BLOCK, BlockCategoryFlags.SHEETMETAL_SLAB, BlockCategoryFlags.SHEETMETAL_STAIRS);
        this.addFlags(BlockCategoryFlags.SCAFFOLDING, ItemCategoryFlags.PLATE, BlockCategoryFlags.ENGINEERING_BLOCK, BlockCategoryFlags.FENCE, BlockCategoryFlags.ADVANCED_ENGINEERING_BLOCK, BlockCategoryFlags.CRATE);
        this.removeMaterialFlags(MaterialFlags.IS_ORE_BEARING);
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("crude_steel_extraction", this.getItemTag(ItemCategoryFlags.PLATE), new ItemStack((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.STEEL), 2));
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("plate_extraction", this.getItemTag(ItemCategoryFlags.PLATE), 1, new ItemStack((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.STEEL), 4), ItemStack.f_41583_).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("light_engineering_extraction", this.getBlock(BlockCategoryFlags.ENGINEERING_BLOCK).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.PLATES.get(EnumMetals.IRON), 2), new ItemStack((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.COPPER)), new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("heavy_engineering_extraction", this.getBlock(BlockCategoryFlags.ADVANCED_ENGINEERING_BLOCK).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.PLATES.get(EnumMetals.STEEL), 2), new ItemStack((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.ELECTRUM)), new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("scaffolding_extraction", this.getScaffoldingBlock().getDefault().m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.PLATES.get(EnumMetals.IRON), 1), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("grate_scaffolding_extraction", this.getScaffoldingBlock().getGrate().m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.PLATES.get(EnumMetals.IRON), 1), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("top_scaffolding_extraction", this.getScaffoldingBlock().getWoodenTop().m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.PLATES.get(EnumMetals.IRON), 1), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("steel_extraction", this.getBlock(BlockCategoryFlags.SHEETMETAL_BLOCK).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.IRON), 6), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("storage_extraction", this.getBlock(BlockCategoryFlags.STORAGE_BLOCK).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.STEEL), 4), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("panel_extraction", this.getBlock(BlockCategoryFlags.DEFAULT_BLOCK).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.PLATES.get(EnumMetals.STEEL), 4), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("stair_extraction", this.getBlock(BlockCategoryFlags.STAIRS).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.STEEL), 2), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("sheetmetal_stair_extraction", this.getBlock(BlockCategoryFlags.SHEETMETAL_STAIRS).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.STEEL), 4), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("slab_extraction", this.getBlock(BlockCategoryFlags.SLAB).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.STEEL), 1), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("sheetmetal_slab_extraction", this.getBlock(BlockCategoryFlags.SHEETMETAL_SLAB).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.STEEL), 3), ItemStack.f_41583_, new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
        IGMethodBuilder.arcSmelting(this, IGStageDesignation.EXTRACTION).create("fence_extraction", this.getBlock(BlockCategoryFlags.FENCE).m_5456_(), 1, new ItemStack((ItemLike)IEItems.Ingredients.STICK_STEEL, 2), new ItemStack((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.STEEL), 1), new IngredientWithSize[0]).setTimeAndEnergy(100, 25600);
    }

    @Override
    public ResourceLocation getTextureLocation(IFlagType<?> flag) {
        if (flag instanceof BlockCategoryFlags) {
            BlockCategoryFlags blockFlag = (BlockCategoryFlags)flag;
            return switch (blockFlag) {
                case BlockCategoryFlags.STORAGE_BLOCK, BlockCategoryFlags.SLAB, BlockCategoryFlags.STAIRS -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/block");
                case BlockCategoryFlags.ENGINEERING_BLOCK -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/light");
                case BlockCategoryFlags.ADVANCED_ENGINEERING_BLOCK -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/heavy");
                case BlockCategoryFlags.DEFAULT_BLOCK -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/deco");
                case BlockCategoryFlags.CRATE -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/crate");
                case BlockCategoryFlags.SCAFFOLDING -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/scaffolding/scaffolding");
                case BlockCategoryFlags.SHEETMETAL_BLOCK, BlockCategoryFlags.SHEETMETAL_SLAB, BlockCategoryFlags.SHEETMETAL_STAIRS -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/sheetmetal");
                default -> super.getTextureLocation(flag);
            };
        }
        if (flag instanceof ItemCategoryFlags) {
            ItemCategoryFlags itemFlag = (ItemCategoryFlags)flag;
            return switch (itemFlag) {
                case ItemCategoryFlags.PLATE -> new ResourceLocation("immersivegeology", "item/colored/rusty_metal/scrap");
                case ItemCategoryFlags.GRIT -> new ResourceLocation("immersivegeology", "block/colored/rusty_metal/scaffolding/scaffolding");
                default -> super.getTextureLocation(flag);
            };
        }
        return new ResourceLocation("immersivegeology", "block/colored/rusty_metal/deco");
    }

    @Override
    public BlockBehaviour.Properties getProperties(IFlagType<?> flag) {
        return super.getProperties(flag).m_60918_(SoundType.f_154663_);
    }
}

