/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.types;

import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class MaterialMetal
extends GeologyMaterial {
    public MaterialMineral.MineralConfig CONFIG = new MaterialMineral.MineralConfig(0, 50, 0, -48, 112, 0, 0.5, false, Optional.empty(), IGGenerationType.DEFAULT);

    public MaterialMetal() {
        this.addFlags(BlockCategoryFlags.SLAB, ItemCategoryFlags.ROD, ItemCategoryFlags.WIRE, ItemCategoryFlags.GRIT, ItemCategoryFlags.METAL_OXIDE, ItemCategoryFlags.COMPOUND_DUST, MaterialFlags.IS_MOLTEN_METAL, MaterialFlags.HAS_SLURRY);
    }

    @Override
    public BlockBehaviour.Properties getProperties(IFlagType<?> flag) {
        return super.getProperties(flag);
    }

    @Override
    public MaterialInterface<?> getPrimaryProduct() {
        return MetalEnum.valueOf(this.unserialized_name);
    }

    @Override
    public void setupRecipeStages() {
        if (this.hasFlag(ItemCategoryFlags.DIRTY_CRUSHED_ORE) && this.hasFlag(ItemCategoryFlags.CRUSHED_ORE)) {
            IGMethodBuilder.separating(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.DIRTY_CRUSHED_ORE, ItemCategoryFlags.CRUSHED_ORE, new ItemStack((ItemLike)Blocks.f_49994_), 0.33f, 100, 100);
            if (this.hasFlag(ItemCategoryFlags.GRIT)) {
                IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
            }
        }
        if (this.hasFlag(ItemCategoryFlags.OXIDE_PELLET)) {
            IGMethodBuilder.pelletize(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.METAL_OXIDE, ItemCategoryFlags.OXIDE_PELLET);
            IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("pellet_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.OXIDE_PELLET), this.getPrimaryProduct().getStack(ItemCategoryFlags.INGOT));
        }
        if (this.hasFlag(ItemCategoryFlags.CRYSTAL) && this.hasFlag(ItemCategoryFlags.INGOT)) {
            IGMethodBuilder.arcSmelting(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRYSTAL, 1, ItemCategoryFlags.INGOT, 1, 0);
        }
        if (this.hasFlag(ItemCategoryFlags.GRIT) && this.hasFlag(ItemCategoryFlags.INGOT)) {
            IGMethodBuilder.arcSmelting(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.GRIT, 1, ItemCategoryFlags.INGOT, 1, 0);
            IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.INGOT, ItemCategoryFlags.GRIT, 3000, 200);
        }
        if (this.hasFlag(ItemCategoryFlags.GRIT) && this.hasFlag(ItemCategoryFlags.CRYSTAL)) {
            IGMethodBuilder.crushing(this, IGStageDesignation.EXTRACTION).create(this.getName() + "_crystal_to_grit", this.getStack(ItemCategoryFlags.CRYSTAL, 1), this.getStack(ItemCategoryFlags.GRIT, 1), 3000, 200);
        }
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return super.getCrystalFamily();
    }

    public record MineralConfig(int veinSize, int rarity, int veinsPerChunk, int minY, int maxY, int generationChance, Optional<TagKey<Biome>> preferredBiome) {
    }
}

