/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper;

import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import com.igteam.immersivegeology.common.block.structural.IGScaffoldingBlock;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;

public class ScaffoldingHelper {
    private final MaterialHelper scaffolding_material;

    public ScaffoldingHelper(MaterialHelper materialHelper) {
        this.scaffolding_material = materialHelper;
    }

    public ScaffoldingHelper(MaterialInterface<?> material) {
        this((MaterialHelper)material.instance());
    }

    public IGScaffoldingBlock getDefault() {
        String key = BlockCategoryFlags.SCAFFOLDING.getRegistryKey(this.scaffolding_material) + "_" + MetalScaffoldingType.STANDARD.name().toLowerCase();
        if (IGRegistrationHolder.getBlockRegistryMap().containsKey(key)) {
            return (IGScaffoldingBlock)IGRegistrationHolder.getBlock.apply(key);
        }
        IGLib.IG_LOGGER.error("Attempting to get a missing block? {}", (Object)key);
        return null;
    }

    public IGScaffoldingBlock getGrate() {
        String key = BlockCategoryFlags.SCAFFOLDING.getRegistryKey(this.scaffolding_material) + "_" + MetalScaffoldingType.GRATE_TOP.name().toLowerCase();
        if (IGRegistrationHolder.getBlockRegistryMap().containsKey(key)) {
            return (IGScaffoldingBlock)IGRegistrationHolder.getBlock.apply(key);
        }
        IGLib.IG_LOGGER.error("Attempting to get a missing block? {}", (Object)key);
        return null;
    }

    public IGScaffoldingBlock getWoodenTop() {
        String key = BlockCategoryFlags.SCAFFOLDING.getRegistryKey(this.scaffolding_material) + "_" + MetalScaffoldingType.WOODEN_TOP.name().toLowerCase();
        if (IGRegistrationHolder.getBlockRegistryMap().containsKey(key)) {
            return (IGScaffoldingBlock)IGRegistrationHolder.getBlock.apply(key);
        }
        IGLib.IG_LOGGER.error("Attempting to get a missing block? {}", (Object)key);
        return null;
    }

    public MaterialHelper getMaterial() {
        return this.scaffolding_material;
    }
}

