/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.flags;

import com.igteam.immersivegeology.client.IGClientRenderHandler;
import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.tag.IGTags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public enum BlockCategoryFlags implements IFlagType<BlockCategoryFlags>
{
    STORAGE_BLOCK(4),
    ORE_BLOCK(0),
    GEODE_BLOCK(0),
    DEFAULT_BLOCK(4),
    SLAB(4),
    DUST_BLOCK(1),
    SHEETMETAL_BLOCK(4),
    SHEETMETAL_SLAB(4),
    SHEETMETAL_STAIRS(4),
    FENCE(4),
    ENERGY_PIPE(4),
    HYDROVENT(0),
    STAIRS(4),
    FLUID(3),
    SLURRY(3),
    CLOUDY_SLURRY(3),
    SCAFFOLDING(4),
    EVAPORATE(0),
    EVAPORATE_CRYSTAL(0),
    ENGINEERING_BLOCK(4),
    ADVANCED_ENGINEERING_BLOCK(4),
    CRATE(4),
    MISC(4);

    private final int groupOrdinal;

    private BlockCategoryFlags(int ordinal) {
        this.groupOrdinal = ordinal;
    }

    @Override
    public BlockCategoryFlags getValue() {
        return this;
    }

    @Override
    public String getTagPrefix() {
        return "";
    }

    @Override
    public ItemSubGroup getSubGroup() {
        return ItemSubGroup.values()[this.groupOrdinal];
    }

    @Override
    public IGClientRenderHandler.RenderTypeSkeleton getRenderType() {
        if (this == ORE_BLOCK || this == EVAPORATE_CRYSTAL) {
            return IGClientRenderHandler.RenderTypeSkeleton.CUTOUT_MIPPED;
        }
        if (this == ENERGY_PIPE) {
            return IGClientRenderHandler.RenderTypeSkeleton.TRANSLUCENT;
        }
        return IFlagType.super.getRenderType();
    }

    public int getVariations() {
        return switch (this) {
            case STORAGE_BLOCK -> 1;
            default -> 1;
        };
    }

    public boolean hasPalette() {
        return switch (this) {
            case STORAGE_BLOCK -> true;
            default -> false;
        };
    }

    public TagKey<Block> getCategoryTag() {
        return IGTags.BLOCK_CATEGORY_FLAGS.get(this);
    }
}

