/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.igteam.immersivegeology.client.helper.IGVeinTextureType;
import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.item.IGGenericDrillHead;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public interface MaterialInterface<T extends GeologyMaterial> {
    public T instance();

    default public ItemStack getStack(ItemCategoryFlags flag) {
        return this.instance().getStack(flag, 1);
    }

    default public ItemStack getStack(IFlagType<?> flag) {
        ItemStack itemStack;
        if (flag instanceof ItemCategoryFlags) {
            ItemCategoryFlags iflag = (ItemCategoryFlags)flag;
            itemStack = this.getStack(iflag, 1);
        } else if (flag instanceof BlockCategoryFlags) {
            BlockCategoryFlags bFlag = (BlockCategoryFlags)flag;
            itemStack = this.getStack(bFlag, 1);
        } else {
            itemStack = null;
        }
        return itemStack;
    }

    default public ItemStack getStack(BlockCategoryFlags flag) {
        return this.instance().getStack(flag, 1);
    }

    default public ItemStack getStack(ItemCategoryFlags flag, int amount) {
        return this.instance().getStack(flag, amount);
    }

    default public ItemStack getStack(IFlagType<?> flag, int amount) {
        ItemStack itemStack;
        if (flag instanceof ItemCategoryFlags) {
            ItemCategoryFlags iflag = (ItemCategoryFlags)flag;
            itemStack = this.getStack(iflag, amount);
        } else if (flag instanceof BlockCategoryFlags) {
            BlockCategoryFlags bFlag = (BlockCategoryFlags)flag;
            itemStack = this.getStack(bFlag, amount);
        } else {
            itemStack = null;
        }
        return itemStack;
    }

    default public ItemStack getStack(BlockCategoryFlags flag, int amount) {
        return this.instance().getStack(flag, amount);
    }

    default public int getColor(IFlagType<?> flag, int secondaryColors) {
        return ((GeologyMaterial)this.instance()).getColor(flag, secondaryColors);
    }

    default public Set<IFlagType<?>> getFlags() {
        return ((GeologyMaterial)this.instance()).getFlags();
    }

    default public String getName() {
        return ((GeologyMaterial)this.instance()).getName();
    }

    default public ResourceLocation getTextureLocation(IFlagType<?> flag) {
        return ((GeologyMaterial)this.instance()).getTextureLocation(flag);
    }

    default public boolean hasFlag(IFlagType<?> category) {
        return this.getFlags().contains(category);
    }

    default public TagKey<Item> getItemTag(IFlagType<ItemCategoryFlags> itemFlag) {
        return this.instance().getItemTag(itemFlag);
    }

    default public FluidType.Properties getFluidProperties() {
        return ((GeologyMaterial)this.instance()).getFluidProperties(BlockCategoryFlags.FLUID);
    }

    default public TagKey<Fluid> getFluidTag(BlockCategoryFlags flag) {
        return ((GeologyMaterial)this.instance()).getFluidTag(flag);
    }

    default public TagKey<Fluid> getFluidTag() {
        return ((GeologyMaterial)this.instance()).getFluidTag();
    }

    @Nullable
    default public TagKey<Fluid> getFluidTag(BlockCategoryFlags flag, MaterialInterface<?> ... extras) {
        return ((GeologyMaterial)this.instance()).getFluidTag(flag, extras);
    }

    @Nullable
    default public TagKey<Fluid> getFluidTag(BlockCategoryFlags flag, MaterialHelper ... extras) {
        return ((GeologyMaterial)this.instance()).getFluidTag(flag, extras);
    }

    default public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return this.instance().getDerivedMaterials();
    }

    default public void buildRecipe() {
        this.instance().buildRecipe();
    }

    default public Set<IGRecipeStage> getStageSet() {
        return this.instance().getStageSet();
    }

    default public Fluid getFluid(BlockCategoryFlags flag) {
        return this.instance().getFluid(flag);
    }

    default public Block getBlock(BlockCategoryFlags flag) {
        return this.instance().getBlock(flag);
    }

    default public IOreBlock getOreBlock(StoneEnum stone, OreRichness richness) {
        return this.instance().getOreBlock(stone, richness);
    }

    default public IOreBlock getOreBlock(MaterialHelper stone, OreRichness richness) {
        return this.instance().getOreBlock(stone, richness);
    }

    default public Item getItem(ItemCategoryFlags itemCategoryFlags) {
        return this.instance().getItem(itemCategoryFlags);
    }

    default public boolean canTarnish() {
        return this.instance().canTarnish();
    }

    default public IGVeinTextureType getVeinTextureType() {
        return this.instance().getVeinTextureType();
    }

    default public MaterialInterface<?> getPrimaryProduct() {
        return ((GeologyMaterial)this.instance()).getPrimaryProduct();
    }

    default public MaterialInterface<?> getSecondaryProduct() {
        return ((GeologyMaterial)this.instance()).getSecondaryProduct();
    }

    default public MaterialInterface<?> getTraceProduct(int index) {
        return ((GeologyMaterial)this.instance()).getTraceProduct(index);
    }

    default public boolean useSedimentaryTextures(IFlagType<?> flag) {
        return this.instance().useColumnBlockStyle(flag);
    }

    default public Set<MaterialHelper> getOriginMaterials() {
        return this.instance().getOriginMaterials();
    }

    default public Rarity getRarity() {
        return ((GeologyMaterial)this.instance()).getRarity();
    }

    default public boolean hasBurnTime() {
        return ((GeologyMaterial)this.instance()).canBurn();
    }

    default public int getBurnTime() {
        return ((GeologyMaterial)this.instance()).getBurntime();
    }

    default public IGGenericDrillHead.DrillHeadProps drillHeadInstance() {
        return this.instance().drillHeadInstance();
    }

    default public IWorldGenConfig getConfig() {
        return null;
    }

    default public String getTranslationName() {
        return Component.m_237115_((String)("material.immersivegeology." + this.getName().toLowerCase())).getString();
    }

    default public float getDefaultNoiseProbability() {
        return ((GeologyMaterial)this.instance()).getNoiseProbability();
    }

    default public void fluidTick(Level level, BlockPos pos, FluidState state) {
        ((GeologyMaterial)this.instance()).fluidTick(level, pos, state);
    }

    default public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ((GeologyMaterial)this.instance()).entityInside(state, level, pos, entity);
    }

    default public boolean fluidSpreadEvent(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        return ((GeologyMaterial)this.instance()).fluidSpreadEvent(level, pos, state, direction, fluidState);
    }

    default public boolean canFormMB(MultiblockHandler.IMultiblock multiblock) {
        return ((GeologyMaterial)this.instance()).canFormMB(multiblock);
    }

    default public TagKey<Block> getBlockMaterialTag() {
        return ((GeologyMaterial)this.instance()).getBlockMaterialTag();
    }

    default public TagKey<Item> getItemMaterialTag() {
        return ((GeologyMaterial)this.instance()).getItemMaterialTag();
    }

    default public int getToolDamage() {
        return this.instance().getToolDamage();
    }

    default public int getToolSpeed() {
        return this.instance().getToolSpeed();
    }

    default public Tier getToolTier() {
        return this.instance().getToolTier();
    }

    default public boolean hasCustomTexture(BlockCategoryFlags blockCategoryFlags) {
        return this.instance().hasCustomTexture(blockCategoryFlags);
    }
}

