/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe;

import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class IGRecipeMethod {
    protected final MaterialHelper parentMaterial;
    private IGRecipeNode node;
    protected int render_x_space;
    private static final HashMap<String, Integer> PATH_COUNT = new HashMap();

    public IGRecipeMethod(IGRecipeStage stage) {
        stage.addMethod(this);
        this.parentMaterial = stage.getParentMaterial();
        this.render_x_space = 24;
    }

    public IGRecipeNode getNode() {
        return this.node;
    }

    public void setNode(IGRecipeNode node) {
        this.node = node;
    }

    public IGRecipeNode addToTree(IGRecipeChain chain) {
        chain.addMethod(this);
        return this.getNode();
    }

    public IGRecipeNode addOptionalToTree(IGRecipeChain chain) {
        return chain.addOptionalRoot(this);
    }

    public IGRecipeNode addToTree(IGRecipeChain chain, IGRecipeNode parent) {
        chain.addChild(parent.getMethod(), this);
        return this.getNode();
    }

    public IGRecipeNode joinBranches(IGRecipeChain chain, IGRecipeNode branch1, IGRecipeNode branch2) {
        chain.join(branch1, branch2, this);
        return this.getNode();
    }

    @Nonnull
    public abstract RecipeMethod getMethod();

    public abstract ResourceLocation getLocation();

    protected ResourceLocation toRL(String s) {
        if (!((String)s).contains("/")) {
            s = "crafting/" + (String)s;
        }
        if (PATH_COUNT.containsKey(s)) {
            int count = PATH_COUNT.get(s) + 1;
            PATH_COUNT.put((String)s, count);
            return new ResourceLocation("immersivegeology", (String)s + count);
        }
        PATH_COUNT.put((String)s, 1);
        return new ResourceLocation("immersivegeology", (String)s);
    }

    public void clearRecipePath() {
        PATH_COUNT.clear();
    }

    public abstract String getName();

    public abstract boolean build(Consumer<FinishedRecipe> var1);

    public ItemStack getIconStack() {
        return ItemStack.f_41583_;
    }

    public abstract void render(GuiGraphics var1, ManualScreen var2, int var3, int var4, int var5, int var6);

    public abstract void renderDisplayStack(GuiGraphics var1, ManualScreen var2, int var3, int var4, int var5, int var6);

    public abstract void renderFinalStack(GuiGraphics var1, ManualScreen var2, int var3, int var4, int var5, int var6);

    public void renderItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, int mx, int my) {
        graphics.m_280064_(stack, x, y, mx, my);
        if (mx > x && x + 16 > mx && my > y && y + 16 > my) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, stack, mx, my);
        }
    }

    public void renderFluidStack(GuiGraphics graphics, Fluid stack, int x, int y, int w, int h, int mx, int my) {
        FluidTank tank = new FluidTank(128);
        tank.setFluid(new FluidStack(stack, 128));
        FluidInfoArea fluid = new FluidInfoArea((IFluidTank)tank, new Rect2i(x, y, w, h), 0, 0, 0, 0, this.getMethod().getGuiLocation());
        fluid.draw(graphics);
        if (mx > x && x + w > mx && my > y && y + h > my) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, tank.getFluid().getDisplayName(), mx, my);
        }
    }

    public void renderFluidStack(GuiGraphics graphics, FluidStack originStack, int x, int y, int w, int h, int mx, int my) {
        FluidStack stack = originStack.copy();
        FluidTank tank = new FluidTank(128);
        stack.setAmount(128);
        tank.setFluid(stack);
        FluidInfoArea fluid = new FluidInfoArea((IFluidTank)tank, new Rect2i(x, y, w, h), 0, 0, 0, 0, this.getMethod().getGuiLocation());
        fluid.draw(graphics);
        if (mx > x && x + w > mx && my > y && y + h > my) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, tank.getFluid().getDisplayName(), mx, my);
        }
    }

    public void renderFluidStack(GuiGraphics graphics, Fluid stack, int amount, int x, int y, int w, int h, int mx, int my) {
        FluidTank tank = new FluidTank(amount);
        tank.setFluid(new FluidStack(stack, amount));
        FluidInfoArea fluid = new FluidInfoArea((IFluidTank)tank, new Rect2i(x, y, w, h), 0, 0, 0, 0, this.getMethod().getGuiLocation());
        fluid.draw(graphics);
        if (mx > x && x + w > mx && my > y && y + h > my) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, tank.getFluid().getDisplayName(), mx, my);
        }
    }

    public void renderMB(GuiGraphics graphics, ItemStack stack, int x, int y, int mx, int my) {
        graphics.m_280064_(stack, x, y, mx, my);
        if (mx > x && x + 16 > mx && my > y && y + 16 > my) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, stack.m_41611_(), x, y);
        }
    }

    public int getXSpace() {
        return this.render_x_space;
    }

    public boolean hasAdditionalInputRenders() {
        return false;
    }

    private static String ig(String suffix) {
        return "immersivegeology:" + suffix;
    }

    private static String ie(String suffix) {
        return "immersiveengineering:" + suffix;
    }

    private static String mc(String suffix) {
        return "minecraft:" + suffix;
    }

    protected String create_basic_method_name(IFlagType<?> starting_form, IFlagType<?> output_form) {
        return starting_form.getName().toLowerCase() + "_" + this.parentMaterial.getName() + "_to_" + output_form.getName().toLowerCase();
    }

    protected String create_advanced_method_name(IFlagType<?> starting_form, IFlagType<?> output_form) {
        return starting_form.getName().toLowerCase() + "_" + this.parentMaterial.getName() + "_to_" + this.parentMaterial.getPrimaryProduct().getName() + output_form.getName().toLowerCase();
    }

    protected String create_advanced_method_name(IFlagType<?> output_form) {
        return this.parentMaterial.getName() + "_to_" + this.parentMaterial.getPrimaryProduct().getName() + output_form.getName().toLowerCase();
    }

    protected String create_basic_method_name(IFlagType<?> output_form) {
        return "create_" + this.parentMaterial.getName() + "_" + output_form.getName();
    }

    public static enum RecipeMethod {
        CRAFTING,
        SEPARATOR,
        BLOOMERY,
        CHEMICAL,
        ROASTING,
        CALCINATION,
        CRYSTALLIZATION,
        BLASTING,
        CRUSHING,
        BASIC_SMELTING,
        ARC_SMELTING,
        SYNTHESIS,
        CUTTING,
        REFINING,
        PELLETIZE,
        MIXING,
        CENTRIFUGE;


        public String getMethodName() {
            switch (this) {
                case CRAFTING: {
                    return "crafting_table";
                }
                case CUTTING: {
                    return IGRecipeMethod.ig("hydrojet");
                }
                case BLASTING: {
                    return IGRecipeMethod.ie("crude_blast_furnace");
                }
                case BLOOMERY: {
                    return IGRecipeMethod.ig("bloomery");
                }
                case CHEMICAL: {
                    return IGRecipeMethod.ig("chemical_reactor");
                }
                case CENTRIFUGE: {
                    return IGRecipeMethod.ig("centrifuge");
                }
                case SEPARATOR: {
                    return IGRecipeMethod.ig("gravity_separator");
                }
                case CRUSHING: {
                    return IGRecipeMethod.ie("crusher");
                }
                case ROASTING: {
                    return IGRecipeMethod.ig("reverberation_furnace");
                }
                case SYNTHESIS: {
                    return IGRecipeMethod.ie("refinery");
                }
                case ARC_SMELTING: {
                    return IGRecipeMethod.ie("arc_furnace");
                }
                case CALCINATION: {
                    return IGRecipeMethod.ig("rotarykiln");
                }
                case BASIC_SMELTING: {
                    return IGRecipeMethod.mc("furnace");
                }
                case MIXING: {
                    return IGRecipeMethod.ie("mixer");
                }
                case REFINING: {
                    return IGRecipeMethod.ig("ballmill");
                }
                case PELLETIZE: {
                    return IGRecipeMethod.ig("pelletizer");
                }
                case CRYSTALLIZATION: {
                    return IGRecipeMethod.ig("crystalizer");
                }
            }
            return "unknown";
        }

        public ResourceLocation getGuiLocation() {
            switch (this) {
                case CRAFTING: {
                    return IGLib.makeTextureLocation("manual/crafting_table");
                }
                case CUTTING: {
                    return IGLib.makeTextureLocation("manual/hydrojet");
                }
                case BLASTING: {
                    return IGLib.makeTextureLocation("manual/blast_furnace");
                }
                case BLOOMERY: {
                    return IGLib.makeTextureLocation("manual/bloomery");
                }
                case CHEMICAL: {
                    return IGLib.makeTextureLocation("manual/vat");
                }
                case CRUSHING: {
                    return IGLib.makeTextureLocation("manual/crusher");
                }
                case ROASTING: {
                    return IGLib.makeTextureLocation("manual/reverberation_furnace");
                }
                case SYNTHESIS: {
                    return IGLib.makeTextureLocation("manual/refinery");
                }
                case MIXING: {
                    return IGLib.makeTextureLocation("manual/mixer");
                }
                case ARC_SMELTING: {
                    return IGLib.makeTextureLocation("manual/arc_furnace");
                }
                case CALCINATION: {
                    return IGLib.makeTextureLocation("manual/rotary_kiln");
                }
                case BASIC_SMELTING: {
                    return IGLib.makeTextureLocation("manual/furnace");
                }
                case CENTRIFUGE: {
                    return IGLib.makeTextureLocation("manual/centrifuge");
                }
                case REFINING: {
                    return IGLib.makeTextureLocation("manual/ballmill");
                }
                case SEPARATOR: {
                    return IGLib.makeTextureLocation("manual/gravity_separator");
                }
                case PELLETIZE: {
                    return IGLib.makeTextureLocation("manual/pelletizer");
                }
                case CRYSTALLIZATION: {
                    return IGLib.makeTextureLocation("manual/crystallizer");
                }
            }
            return IGLib.makeTextureLocation("unknown");
        }
    }
}

