/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe;

import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class IGRecipeStage {
    private final String name;
    private String description;
    private Set<IGRecipeMethod> methods = new LinkedHashSet<IGRecipeMethod>();
    private MaterialHelper material;

    public IGRecipeStage(MaterialHelper material, IGStageDesignation designation) {
        this.name = designation.name();
        this.material = material;
        material.addStage(this);
        this.describe();
        this.description = material.getName() + " " + designation.name();
    }

    public IGRecipeStage(MaterialHelper material, IGStageDesignation designation, String description) {
        this(material, designation);
        this.description = description;
    }

    public MaterialHelper getParentMaterial() {
        return this.material;
    }

    protected void describe() {
    }

    public Set<IGRecipeMethod> getMethods() {
        return this.methods;
    }

    public void addMethod(IGRecipeMethod m) {
        this.methods.add(m);
    }

    public String getStageName() {
        return this.name;
    }
}

