/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.helper;

import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IGRecipeChain {
    private final GeologyMaterial material;
    private final String chainName;
    private final int priority;
    private final List<IGRecipeNode> rootNodes = new ArrayList<IGRecipeNode>();

    public IGRecipeChain(GeologyMaterial material, String chainName, int priority) {
        this.material = material;
        this.chainName = chainName.toLowerCase().replace(' ', '_');
        this.priority = priority;
    }

    public void addMethod(IGRecipeMethod method) {
        IGRecipeNode newNode = new IGRecipeNode(method);
        method.setNode(newNode);
        if (this.rootNodes.isEmpty()) {
            this.rootNodes.add(newNode);
        } else {
            IGRecipeNode last = this.getLastNode(this.rootNodes.get(0));
            last.addChild(newNode);
        }
    }

    public IGRecipeNode addOptionalRoot(IGRecipeMethod method) {
        IGRecipeNode newNode = new IGRecipeNode(method);
        method.setNode(newNode);
        this.rootNodes.add(newNode);
        return newNode;
    }

    public void addChild(IGRecipeMethod parentMethod, IGRecipeMethod childMethod) {
        IGRecipeNode parentNode = parentMethod.getNode();
        if (parentNode == null) {
            parentNode = new IGRecipeNode(parentMethod);
            parentMethod.setNode(parentNode);
            if (this.rootNodes.isEmpty()) {
                this.rootNodes.add(parentNode);
            }
        }
        IGRecipeNode childNode = new IGRecipeNode(childMethod);
        childMethod.setNode(childNode);
        parentNode.addChild(childNode);
    }

    public void promoteOptionalRoot(IGRecipeNode optionalRoot, IGRecipeMethod newParentMethod) {
        this.rootNodes.remove(optionalRoot);
        this.addChild(newParentMethod, optionalRoot.getMethod());
    }

    public void join(IGRecipeNode branch1, IGRecipeNode branch2, IGRecipeMethod joinMethod) {
        IGRecipeNode joinNode = new IGRecipeNode(joinMethod);
        joinMethod.setNode(joinNode);
        branch1.addChild(joinNode);
        branch2.addChild(joinNode);
    }

    private IGRecipeNode getLastNode(IGRecipeNode node) {
        if (node.getChildren().isEmpty()) {
            return node;
        }
        return this.getLastNode(node.getChildren().get(0));
    }

    public List<IGRecipeNode> getRootNodes() {
        return this.rootNodes;
    }

    public void layoutRecipeChain(int startX, int startY, int verticalSpacing, int horizontalSpacing) {
        for (IGRecipeNode root : this.rootNodes) {
            root.resetRender();
        }
        int maxDepth = this.calculateMaxDepth();
        int maxWidth = this.calculateMaxWidth();
        int rows = maxDepth + 1;
        int cols = maxWidth * 2 + 1;
        GridCell[][] grid = new GridCell[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                grid[i][j] = new GridCell();
            }
        }
        HashMap<IGRecipeNode, GridPosition> nodePositions = new HashMap<IGRecipeNode, GridPosition>();
        this.placeNodesFirstPass(grid, nodePositions);
        this.adjustForAdjacency(grid, nodePositions);
        for (Map.Entry entry : nodePositions.entrySet()) {
            IGRecipeNode node = (IGRecipeNode)entry.getKey();
            GridPosition pos = (GridPosition)entry.getValue();
            node.setX(startX + pos.col * horizontalSpacing);
            node.setY(startY + pos.row * verticalSpacing);
        }
    }

    private void placeNodesFirstPass(GridCell[][] grid, Map<IGRecipeNode, GridPosition> nodePositions) {
        int centerCol;
        int currentCol = centerCol = grid[0].length / 2;
        for (IGRecipeNode root : this.rootNodes) {
            this.placeSubtree(root, 0, currentCol, grid, nodePositions, new HashSet<IGRecipeNode>());
            currentCol += 2;
        }
    }

    private void placeSubtree(IGRecipeNode node, int row, int col, GridCell[][] grid, Map<IGRecipeNode, GridPosition> nodePositions, Set<IGRecipeNode> visited) {
        if (!visited.add(node) || row >= grid.length || col >= grid[0].length || col < 0) {
            return;
        }
        grid[row][col].place(node);
        nodePositions.put(node, new GridPosition(row, col));
        List<IGRecipeNode> children = node.getChildren();
        if (children.size() == 1) {
            this.placeSubtree(children.get(0), row + 1, col, grid, nodePositions, visited);
        } else if (children.size() > 1) {
            int childStartCol = col - children.size() + 1;
            for (IGRecipeNode child : children) {
                this.placeSubtree(child, row + 1, childStartCol, grid, nodePositions, visited);
                childStartCol += 2;
            }
        }
    }

    private void adjustForAdjacency(GridCell[][] grid, Map<IGRecipeNode, GridPosition> nodePositions) {
        boolean madeAdjustments;
        int maxDepth = 10;
        do {
            madeAdjustments = false;
            for (Map.Entry<IGRecipeNode, GridPosition> entry : new HashMap<IGRecipeNode, GridPosition>(nodePositions).entrySet()) {
                IGRecipeNode node = entry.getKey();
                GridPosition pos = entry.getValue();
                if (!node.getChildren().isEmpty() && !this.hasAdjacentChild(node, grid, pos)) {
                    for (IGRecipeNode child : node.getChildren()) {
                        GridPosition childPos;
                        if (!this.adjustNodePosition(child, childPos = nodePositions.get(child), grid, nodePositions)) continue;
                        madeAdjustments = true;
                    }
                }
                if (maxDepth < 0) {
                    madeAdjustments = false;
                }
                --maxDepth;
            }
        } while (madeAdjustments);
    }

    private boolean hasAdjacentParent(IGRecipeNode node, GridCell[][] grid, GridPosition pos) {
        return this.checkAdjacent(node, grid, pos, node.getParents());
    }

    private boolean hasAdjacentChild(IGRecipeNode node, GridCell[][] grid, GridPosition pos) {
        return this.checkAdjacent(node, grid, pos, node.getChildren());
    }

    private boolean checkAdjacent(IGRecipeNode node, GridCell[][] grid, GridPosition pos, List<IGRecipeNode> relatives) {
        int[][] directions;
        for (int[] dir : directions = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, 1}, {-1, -1}, {1, -1}, {1, 1}}) {
            IGRecipeNode adjacent;
            int newRow = pos.row + dir[0];
            int newCol = pos.col + dir[1];
            if (!this.isValidPosition(newRow, newCol, grid) || (adjacent = grid[newRow][newCol].node) == null || !relatives.contains(adjacent)) continue;
            return true;
        }
        return false;
    }

    private boolean adjustNodePosition(IGRecipeNode node, GridPosition pos, GridCell[][] grid, Map<IGRecipeNode, GridPosition> nodePositions) {
        int[][] directions;
        for (int[] dir : directions = new int[][]{{0, 1}, {0, -1}, {1, 0}, {-1, 0}, {-1, 1}, {-1, -1}, {1, -1}, {1, 1}}) {
            int newRow = pos.row + dir[0];
            int newCol = pos.col + dir[1];
            if (!this.isValidPosition(newRow, newCol, grid) || grid[newRow][newCol].occupied) continue;
            grid[pos.row][pos.col].clear();
            grid[newRow][newCol].place(node);
            nodePositions.put(node, new GridPosition(newRow, newCol));
            return true;
        }
        return false;
    }

    private boolean isValidPosition(int row, int col, GridCell[][] grid) {
        return row >= 0 && row < grid.length && col >= 0 && col < grid[0].length;
    }

    private int calculateMaxDepth() {
        HashSet<IGRecipeNode> visited = new HashSet<IGRecipeNode>();
        int maxDepth = 0;
        for (IGRecipeNode root : this.rootNodes) {
            maxDepth = Math.max(maxDepth, this.calculateDepthRecursive(root, visited));
        }
        return maxDepth;
    }

    private int calculateDepthRecursive(IGRecipeNode node, Set<IGRecipeNode> visited) {
        if (!visited.add(node)) {
            return 0;
        }
        if (node.getChildren().isEmpty()) {
            return 0;
        }
        int maxChildDepth = 0;
        for (IGRecipeNode child : node.getChildren()) {
            maxChildDepth = Math.max(maxChildDepth, this.calculateDepthRecursive(child, visited));
        }
        return maxChildDepth + 1;
    }

    private int calculateMaxWidth() {
        int width = this.rootNodes.size();
        HashSet<IGRecipeNode> visited = new HashSet<IGRecipeNode>();
        for (IGRecipeNode root : this.rootNodes) {
            width = Math.max(width, this.calculateWidthRecursive(root, visited));
        }
        return width;
    }

    private int calculateWidthRecursive(IGRecipeNode node, Set<IGRecipeNode> visited) {
        if (!visited.add(node)) {
            return 0;
        }
        int width = Math.max(1, node.getChildren().size());
        for (IGRecipeNode child : node.getChildren()) {
            width = Math.max(width, this.calculateWidthRecursive(child, visited));
        }
        return width;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.chainName.toLowerCase();
    }

    private static class GridCell {
        IGRecipeNode node;
        boolean occupied;

        private GridCell() {
        }

        void clear() {
            this.node = null;
            this.occupied = false;
        }

        void place(IGRecipeNode node) {
            this.node = node;
            this.occupied = true;
        }
    }

    private static class GridPosition {
        int row;
        int col;

        GridPosition(int row, int col) {
            this.row = row;
            this.col = col;
        }
    }
}

