/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class IGBasicSmeltingMethod
extends IGRecipeMethod {
    private ItemLike input;
    private ItemLike output;
    private int smeltingTime;
    private float xp;

    public IGBasicSmeltingMethod(IGRecipeStage stage) {
        super(stage);
    }

    public IGBasicSmeltingMethod(MaterialHelper material, IGStageDesignation stage) {
        super(new IGRecipeStage(material, stage){});
    }

    public IGBasicSmeltingMethod create(ItemLike input, ItemLike output) {
        this.input = input;
        this.output = output;
        this.smeltingTime = 100;
        this.xp = 1.0f;
        return this;
    }

    public IGBasicSmeltingMethod create(IFlagType<?> input, IFlagType<?> output) {
        this.input = this.parentMaterial.getStack(input, 1).m_41720_();
        this.output = this.parentMaterial.getStack(output, 1).m_41720_();
        this.smeltingTime = 100;
        this.xp = 1.0f;
        return this;
    }

    public IGBasicSmeltingMethod create(IFlagType<?> input, IFlagType<?> output, int time) {
        this.input = this.parentMaterial.getStack(input, 1).m_41720_();
        this.output = this.parentMaterial.getStack(output, 1).m_41720_();
        this.smeltingTime = time;
        this.xp = 1.0f;
        return this;
    }

    public IGBasicSmeltingMethod create(IFlagType<?> input, IFlagType<?> output, int time, int xp) {
        this.input = this.parentMaterial.getStack(input, 1).m_41720_();
        this.output = this.parentMaterial.getStack(output, 1).m_41720_();
        this.smeltingTime = time;
        this.xp = xp;
        return this;
    }

    public void setTimeAndXP(int smeltingTime, float xp) {
        this.smeltingTime = smeltingTime;
        this.xp = xp;
    }

    @Override
    public ItemStack getIconStack() {
        return new ItemStack((ItemLike)Blocks.f_50094_);
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, new ItemStack((ItemLike)this.input.m_5456_()), x, y, mx, my);
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.BASIC_SMELTING;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL(this.input.m_5456_().m_5524_() + "_to_" + this.output.m_5456_().m_5524_() + "_from_blasting");
    }

    @Override
    public String getName() {
        return this.input.m_5456_().m_5524_() + "_to_" + this.output.m_5456_().m_5524_() + "_from_blasting";
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)this.output, (float)this.xp, (int)this.smeltingTime).m_126132_("has_" + this.input.m_5456_().m_5524_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{this.input})).m_126140_(consumer, this.getLocation());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

