/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.RotaryKilnRecipeBuilder;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class IGCalcinationMethod
extends IGRecipeMethod {
    private int time;
    private int heat = 75;
    private IngredientWithSize input;
    private ItemStack output;
    private String name;

    public IGCalcinationMethod(MaterialHelper parent, IGStageDesignation stage) {
        super(new IGRecipeStage(parent, stage){});
    }

    public IGCalcinationMethod create(String name, ItemStack output, TagKey<Item> inputTag, int itemAmount, int time) {
        this.name = name;
        this.output = output;
        this.input = new IngredientWithSize(inputTag, itemAmount);
        this.time = time;
        return this;
    }

    public IGCalcinationMethod create(IFlagType<?> output_form, IFlagType<?> input_form, int itemAmount, int time) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), itemAmount);
        this.time = time;
        return this;
    }

    public IGCalcinationMethod create(IFlagType<?> output_form, IngredientWithSize input_form, int time) {
        this.name = this.create_basic_method_name(output_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.input = input_form;
        this.time = time;
        return this;
    }

    public IGCalcinationMethod create(IFlagType<?> output_form, IngredientWithSize input_form, int time, int output_amount) {
        this.name = this.create_basic_method_name(output_form);
        this.output = this.parentMaterial.getStack(output_form, output_amount);
        this.input = input_form;
        this.time = time;
        return this;
    }

    public IGCalcinationMethod create(IFlagType<?> input_form, IFlagType<?> output_form, MaterialHelper output_material, int itemAmount, int time) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = output_material.getStack(output_form, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), itemAmount);
        this.time = time;
        return this;
    }

    public IGCalcinationMethod create(IFlagType<?> input_form, int input_amount, IFlagType<?> output_form, MaterialHelper output_material, int output_amount, int time) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = output_material.getStack(output_form, output_amount);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), input_amount);
        this.time = time;
        return this;
    }

    public IGCalcinationMethod setLVHeat() {
        this.heat = 30;
        return this;
    }

    public IGCalcinationMethod setMVHeat() {
        this.heat = 75;
        return this;
    }

    public IGCalcinationMethod setHVHeat() {
        this.heat = 120;
        return this;
    }

    public IGCalcinationMethod setEHVHeat() {
        this.heat = 165;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.CALCINATION;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("calcination/decompose_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.ROTARYKILN.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x + 25, y + 2, mx, my);
        this.renderItemStack(graphics, this.output, x + 59, y + 2, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            RotaryKilnRecipeBuilder builder = RotaryKilnRecipeBuilder.builder(this.output);
            builder.addInput(this.input);
            builder.setTime(this.time);
            builder.setHeat(this.heat);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

