/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.CrystallizerRecipeBuilder;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.types.MaterialChemical;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class IGCrystallizationMethod
extends IGRecipeMethod {
    private ItemStack itemResult;
    private Lazy<FluidTagInput> fluidInput;
    private TagKey<Fluid> fluid_tag;
    private int time;
    private int energy;
    private String name;
    private FluidStack fluid_out;

    public IGCrystallizationMethod(MaterialHelper material, IGStageDesignation stage) {
        super(new IGRecipeStage(material, stage){});
    }

    public IGCrystallizationMethod create(MaterialInterface<?> slurry_base, IFlagType<?> output_form) {
        this.name = this.create_advanced_method_name(ItemCategoryFlags.CRYSTAL);
        Object obj = slurry_base.instance();
        if (obj instanceof MaterialChemical) {
            MaterialChemical chemical = (MaterialChemical)obj;
            this.itemResult = this.parentMaterial.getPrimaryProduct().getStack(output_form, 1);
            this.fluid_tag = chemical.getFluidTag(BlockCategoryFlags.SLURRY, this.parentMaterial.getPrimaryProduct());
            this.fluidInput = () -> new FluidTagInput(this.fluid_tag, 144);
            this.time = 300;
            this.fluid_out = new FluidStack(chemical.getFluid(BlockCategoryFlags.FLUID), 120);
            this.energy = 38400;
            if (this.fluid_tag == null) {
                throw new RuntimeException("Fluid Tag Returned Was Null, IDK why.");
            }
        } else {
            throw new RuntimeException("Slurry Base Chemical IS Not of Chemical Type");
        }
        return this;
    }

    public IGCrystallizationMethod create(MaterialInterface<?> slurry_base, MaterialInterface<?> slurry_product) {
        this.name = this.create_advanced_method_name(ItemCategoryFlags.CRYSTAL);
        Object obj = slurry_base.instance();
        if (obj instanceof MaterialChemical) {
            MaterialChemical chemical = (MaterialChemical)obj;
            this.itemResult = slurry_product.getStack(ItemCategoryFlags.CRYSTAL, 1);
            this.fluid_tag = chemical.getFluidTag(BlockCategoryFlags.SLURRY, slurry_product);
            this.fluidInput = () -> new FluidTagInput(this.fluid_tag, 144);
            this.time = 300;
            this.fluid_out = new FluidStack(chemical.getFluid(BlockCategoryFlags.FLUID), 120);
            this.energy = 38400;
            if (this.fluid_tag == null) {
                throw new RuntimeException("Fluid Tag Returned Was Null, IDK why.");
            }
        } else {
            throw new RuntimeException("Slurry Base Chemical IS Not of Chemical Type");
        }
        return this;
    }

    public IGCrystallizationMethod create(String name, ItemStack output, MaterialInterface<?> slurry_base, MaterialInterface<?> slurry_product, int fluidAmount, int time, int energy) {
        this.name = name;
        Object obj = slurry_base.instance();
        if (obj instanceof MaterialChemical) {
            MaterialChemical chemical = (MaterialChemical)obj;
            this.itemResult = output;
            this.fluid_tag = chemical.getFluidTag(BlockCategoryFlags.SLURRY, slurry_product);
            this.fluidInput = () -> new FluidTagInput(this.fluid_tag, fluidAmount);
            this.time = time;
            this.fluid_out = new FluidStack(chemical.getFluid(BlockCategoryFlags.FLUID), 120);
            this.energy = energy;
            if (this.fluid_tag == null) {
                throw new RuntimeException("Fluid Tag Returned Was Null, IDK why.");
            }
        } else {
            throw new RuntimeException("Slurry Base Chemical IS Not of Chemical Type");
        }
        return this;
    }

    public IGCrystallizationMethod create(String name, ItemStack output, FluidStack fluid_out, TagKey<Fluid> fluidTag, int fluidAmount, int time, int energy) {
        this.name = name;
        if (fluidTag == null) {
            throw new RuntimeException("Fluid Tag is NULL... why? for Method: " + name);
        }
        this.itemResult = output;
        this.fluid_tag = fluidTag;
        this.fluidInput = () -> new FluidTagInput(fluidTag, fluidAmount);
        this.fluid_out = fluid_out;
        this.time = time;
        this.energy = energy;
        return this;
    }

    public IGCrystallizationMethod create(String name, ItemStack output, FluidStack fluid_out, MaterialInterface<?> slurry_base, MaterialInterface<?> slurry_product, int fluidAmount, int time, int energy) {
        this.name = name;
        Object obj = slurry_base.instance();
        if (obj instanceof MaterialChemical) {
            MaterialChemical chemical = (MaterialChemical)obj;
            this.itemResult = output;
            this.fluid_tag = chemical.getFluidTag(BlockCategoryFlags.SLURRY, slurry_product);
            this.fluidInput = () -> new FluidTagInput(this.fluid_tag, fluidAmount);
            this.fluid_out = fluid_out;
            this.time = time;
            this.energy = energy;
            if (this.fluid_tag == null) {
                throw new RuntimeException("Fluid Tag Returned Was Null, IDK why.");
            }
        } else {
            throw new RuntimeException("Slurry Base Chemical IS Not of Chemical Type");
        }
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.CRYSTALLIZATION;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("crystallizer/crystallize_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.CRYSTALLIZER.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderFluidStack(graphics, ((FluidTagInput)this.fluidInput.get()).getRandomizedExampleStack(0).getFluid(), x + 24, y + 11, 16, 16, mx, my);
        if (this.fluid_out != null && !this.fluid_out.isEmpty()) {
            this.renderFluidStack(graphics, this.fluid_out.getFluid(), x + 61, y + 21, 16, 16, mx, my);
        }
        this.renderItemStack(graphics, this.itemResult, x + 61, y + 2, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderFluidStack(graphics, ((FluidTagInput)this.fluidInput.get()).getRandomizedExampleStack(0).getFluid(), x, y, 16, 16, mx, my);
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.itemResult, x, y, mx, my);
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            CrystallizerRecipeBuilder builder = (CrystallizerRecipeBuilder)((CrystallizerRecipeBuilder)CrystallizerRecipeBuilder.builder(this.itemResult, this.fluid_out).addInput((FluidTagInput)this.fluidInput.get()).setEnergy(this.energy)).setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error("Exception in Crystallizer Recipe Builder: {}", (Object)e.getMessage());
            IGLib.IG_LOGGER.error("Fluid Tag was {}", (Object)this.fluid_tag.toString());
            return false;
        }
    }
}

