/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.builders.RefineryRecipeBuilder;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class IGRefineryMethod
extends IGRecipeMethod {
    FluidStack output;
    Item catalyst;
    TagKey<Fluid> fluid_input_a;
    TagKey<Fluid> fluid_input_b;
    int input_fluid_a_amount;
    int input_fluid_b_amount;
    String name;

    public IGRefineryMethod(IGRecipeStage stage) {
        super(stage);
    }

    public IGRefineryMethod(MaterialHelper parent, IGStageDesignation stage) {
        super(new IGRecipeStage(parent, stage){});
    }

    public IGRefineryMethod create(String name, TagKey<Fluid> fluid_input_a, int a_amount, TagKey<Fluid> fluid_input_b, int b_amount, Item catalyst, FluidStack output) {
        this.output = output;
        this.fluid_input_a = fluid_input_a;
        this.fluid_input_b = fluid_input_b;
        this.input_fluid_a_amount = a_amount;
        this.input_fluid_b_amount = b_amount;
        this.catalyst = catalyst;
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.SYNTHESIS;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("refinery/synthesis_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return new ItemStack((ItemLike)IEMultiblocks.REFINERY.getBlock());
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, new ItemStack((ItemLike)this.catalyst), x, y, mx, my);
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(this.output);
        FluidInfoArea fluid = new FluidInfoArea((IFluidTank)tank, new Rect2i(x, y, 16, 16), 0, 0, 0, 0, IGLib.makeTextureLocation("reverberation_furnace"));
        fluid.draw(graphics);
        this.render_x_space = 48;
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            RefineryRecipeBuilder builder = RefineryRecipeBuilder.builder((FluidStack)this.output);
            builder.addCatalyst((ItemLike)this.catalyst);
            builder.addInput(new FluidTagInput(this.fluid_input_a, this.input_fluid_a_amount));
            builder.addInput(new FluidTagInput(this.fluid_input_b, this.input_fluid_b_amount));
            builder.setEnergy(80);
            builder.setTime(1);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error(e.getLocalizedMessage());
            return false;
        }
    }
}

