/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.RevFurnaceRecipeBuilder;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class IGRoastingMethod
extends IGRecipeMethod {
    private ItemStack itemResult;
    private IngredientWithSize itemInput;
    private TagKey<Item> itemTag;
    private int time;
    private int waste_amount;
    private String name;

    public IGRoastingMethod(MaterialHelper parentMaterial, IGStageDesignation stage) {
        super(new IGRecipeStage(parentMaterial, stage){});
    }

    public IGRoastingMethod create(String name, TagKey<Item> itemInput, int inputAmount, ItemStack output, int time, int waste_amount) {
        this.name = name;
        this.itemTag = itemInput;
        this.itemResult = output;
        this.itemInput = new IngredientWithSize(itemInput, inputAmount);
        this.time = time;
        this.waste_amount = waste_amount;
        return this;
    }

    public IGRoastingMethod create(IFlagType<?> input, int inputAmount, IFlagType<?> output, int outputAmount, int time, int waste_amount) {
        this.name = this.create_basic_method_name(input, output);
        this.itemTag = this.parentMaterial.getItemTag(input);
        this.itemResult = this.parentMaterial.getStack(output, outputAmount);
        this.itemInput = new IngredientWithSize(this.itemTag, inputAmount);
        this.time = time;
        this.waste_amount = waste_amount;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.ROASTING;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("roasting/roast_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.REVERBERATION_FURNACE.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.itemInput.getRandomizedExampleStack(0), x + 24, y + 11, mx, my);
        this.renderItemStack(graphics, this.itemResult, x + 60, y + 2, mx, my);
        this.renderFluidStack(graphics, ChemicalEnum.SulfurDioxde.getFluid(BlockCategoryFlags.FLUID), 70, 21, 16, 16, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.itemInput.getRandomizedExampleStack(0), x, y, mx, my);
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            RevFurnaceRecipeBuilder builder = RevFurnaceRecipeBuilder.builder(this.itemResult);
            builder.addInput(this.itemInput);
            builder.setWasteAmount(this.waste_amount);
            builder.setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error("Exception Building Immersive Geology Roasting Recipe: {}", (Object)e.getMessage());
            return false;
        }
    }
}

