/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.registration;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.Tree;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.client.manual.IGRecipeOverview;
import com.igteam.immersivegeology.client.menu.IGCrateScreen;
import com.igteam.immersivegeology.client.menu.multiblock.BloomeryScreen;
import com.igteam.immersivegeology.client.menu.multiblock.ChemicalReactorScreen;
import com.igteam.immersivegeology.client.menu.multiblock.CrystallizerScreen;
import com.igteam.immersivegeology.client.menu.multiblock.GeothermalExchangerScreen;
import com.igteam.immersivegeology.client.menu.multiblock.ReverberationScreen;
import com.igteam.immersivegeology.client.menu.multiblock.RotaryKilnScreen;
import com.igteam.immersivegeology.client.menu.multiblock.SmallChemicalReactorScreen;
import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipeEntity;
import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.registration.IGMenuTypes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class IGContent {
    static List<MaterialInterface<?>> metals = List.of(MetalEnum.values());
    ChemthrowerHandler.ChemthrowerEffect acidic = new ChemthrowerHandler.ChemthrowerEffect(){

        public void applyToEntity(LivingEntity livingEntity, @Nullable Player player, ItemStack itemStack, Fluid fluid) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 1));
        }

        public void applyToBlock(Level level, HitResult hitResult, @Nullable Player player, ItemStack itemStack, Fluid fluid) {
            Vec3 vec = hitResult.m_82450_();
            BlockPos loc = new BlockPos((int)vec.m_7096_(), (int)vec.m_7098_(), (int)vec.m_7094_());
            BlockState state = level.m_8055_(new BlockPos((Vec3i)loc));
            if (state.m_60713_(Blocks.f_50440_)) {
                level.m_7731_(loc, Blocks.f_50493_.m_49966_(), 0);
            }
            if (state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_)) {
                level.m_7731_(loc, Blocks.f_50016_.m_49966_(), 0);
            }
        }
    };

    public static void initializeIETweaks() {
        IGLib.IG_LOGGER.info("======== Registration of Immersive Geology IE Tweaks ========");
        IGLib.IG_LOGGER.info("- Custom Chemical Thrower Recipes and Effects");
        ChemthrowerHandler.registerEffect(ChemicalEnum.ChemicalWaste.getFluidTag(), (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect(){

            public void applyToEntity(LivingEntity livingEntity, @Nullable Player player, ItemStack itemStack, Fluid fluid) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 50));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 140));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1));
                RandomSource rand = livingEntity.m_217043_();
                if (rand.m_188501_() > 0.5f) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 1));
                }
            }

            public void applyToBlock(Level level, HitResult hitResult, @Nullable Player player, ItemStack itemStack, Fluid fluid) {
                Vec3 vec = hitResult.m_82450_();
                BlockPos loc = new BlockPos((int)vec.m_7096_(), (int)vec.m_7098_(), (int)vec.m_7094_()).m_7495_();
                BlockState state = level.m_8055_(new BlockPos((Vec3i)loc));
                RandomSource random = level.m_213780_();
                if (state.m_60713_(Blocks.f_50440_)) {
                    level.m_7731_(loc, Blocks.f_50493_.m_49966_(), 3);
                }
                if (state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_)) {
                    level.m_7731_(loc, Blocks.f_50016_.m_49966_(), 0);
                }
                if (state.m_60713_(Blocks.f_50546_)) {
                    level.m_7731_(loc, Blocks.f_50493_.m_49966_(), 3);
                }
                if (state.m_60713_(Blocks.f_50493_) && random.m_188503_(10) == 1) {
                    level.m_7731_(loc, Blocks.f_49994_.m_49966_(), 3);
                }
                if (state.m_60713_(Blocks.f_49994_) && random.m_188503_(15) == 1) {
                    level.m_7731_(loc, Blocks.f_49992_.m_49966_(), 3);
                }
            }
        });
        ChemthrowerHandler.registerEffect(ChemicalEnum.SulfuricAcid.getFluidTag(), (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect(){

            public void applyToEntity(LivingEntity livingEntity, @Nullable Player player, ItemStack itemStack, Fluid fluid) {
                if (!(livingEntity instanceof Skeleton)) {
                    livingEntity.m_20254_(5);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 10, 0));
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)IEPotions.FLAMMABLE.get(), 100, 0));
                }
            }

            public void applyToBlock(Level level, HitResult hitResult, @Nullable Player player, ItemStack itemStack, Fluid fluid) {
            }
        });
        IGEnergyPipeEntity.initCovers();
        IGLib.IG_LOGGER.info("Finished");
    }

    public static void registerContainersAndScreens() {
        MenuScreens.m_96206_(IGMenuTypes.BLOOMERY.getType(), BloomeryScreen::new);
        MenuScreens.m_96206_(IGMenuTypes.REVERBERATION_FURNACE.getType(), ReverberationScreen::new);
        MenuScreens.m_96206_(IGMenuTypes.GEOTHERMAL_EXCHANGER.getType(), GeothermalExchangerScreen::new);
        MenuScreens.m_96206_(IGMenuTypes.CRYSTALLIZER.getType(), CrystallizerScreen::new);
        MenuScreens.m_96206_(IGMenuTypes.CHEMICAL_REACTOR.getType(), ChemicalReactorScreen::new);
        MenuScreens.m_96206_(IGMenuTypes.SMALL_CHEMICAL_REACTOR.getType(), SmallChemicalReactorScreen::new);
        MenuScreens.m_96206_(IGMenuTypes.ROTARY_KILN.getType(), RotaryKilnScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)IGMenuTypes.CRATE.get()), IGCrateScreen.StandardIGCrate::new);
    }

    public static void initializeManualEntries() {
        ManualInstance instance = ManualHelper.getManual();
        instance.registerSpecialElement(new ResourceLocation("immersivegeology", "recipe_overview"), s -> {
            String mineral_name = GsonHelper.m_13906_((JsonObject)s, (String)"mineral");
            MaterialMineral material = MineralEnum.valueOf(mineral_name).instance();
            int priority = GsonHelper.m_13927_((JsonObject)s, (String)"priority");
            return new IGRecipeOverview(instance, (GeologyMaterial)material, priority);
        });
        Tree.InnerNode parent_category = instance.getRoot().getOrCreateSubnode((Comparable)new ResourceLocation("immersivegeology", "main"), 99);
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(new ResourceLocation("immersivegeology", "intro"));
        instance.addEntry(parent_category, builder.create());
        Tree.InnerNode multiblock_category = parent_category.getOrCreateSubnode((Comparable)new ResourceLocation("immersivegeology", "ig_multiblocks"), 0);
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "crystallizer");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "coredrill");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "gravity_separator");
        IGContent.multiblockRotaryKilnEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "rotary_kiln");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "reverberation_furnace");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "geothermal_exchanger");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "bloomery");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "chemical_reactor");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "ballmill");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "centrifuge");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "pelletizer");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "steam_turbine");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "alternator");
        IGContent.multiblockEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)multiblock_category, "small_chemical_reactor");
        builder.readFromFile(new ResourceLocation("immersivegeology", "getting_started"));
        instance.addEntry(parent_category, builder.create());
        builder.readFromFile(new ResourceLocation("immersivegeology", "bug_bounty_contributors"));
        instance.addEntry(parent_category, builder.create());
        Tree.InnerNode geology = parent_category.getOrCreateSubnode((Comparable)new ResourceLocation("immersivegeology", "ig_geology"), 2);
        Tree.InnerNode overworld = geology.getOrCreateSubnode((Comparable)new ResourceLocation("immersivegeology", "overworld"), 0);
        Tree.InnerNode nether = geology.getOrCreateSubnode((Comparable)new ResourceLocation("immersivegeology", "nether"), 1);
        Tree.InnerNode the_end = geology.getOrCreateSubnode((Comparable)new ResourceLocation("immersivegeology", "the_end"), 2);
        LinkedList<MaterialInterface<?>> materials = IGLib.getGeneratedMaterials();
        for (MaterialInterface materialInterface : materials) {
            if (materialInterface.instance().acceptableStoneType(StoneEnum.MCStone)) {
                IGContent.mineralTreeEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)overworld, materialInterface);
            }
            if (materialInterface.instance().acceptableStoneType(StoneEnum.MCNetherrack)) {
                IGContent.mineralTreeEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)nether, materialInterface);
            }
            if (!materialInterface.instance().acceptableStoneType(StoneEnum.MCEndStone)) continue;
            IGContent.mineralTreeEntry(instance, (Tree.InnerNode<ResourceLocation, ManualEntry>)the_end, materialInterface);
        }
    }

    private static void mineralTreeEntry(ManualInstance instance, Tree.InnerNode<ResourceLocation, ManualEntry> category, MaterialInterface<?> material) {
        ManualEntry.ManualEntryBuilder mineral = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        mineral.setLocation(new ResourceLocation("immersivegeology", material.getName()));
        mineral.setContent(() -> IGContent.createMineralContent(material));
        instance.addEntry(category, mineral.create());
    }

    private static void metalTreeEntry(ManualInstance instance, Tree.InnerNode<ResourceLocation, ManualEntry> category, MaterialInterface<?> material) {
        ManualEntry.ManualEntryBuilder mineral = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        mineral.setLocation(new ResourceLocation("immersivegeology", material.getName()));
        mineral.setContent(() -> IGContent.createMineralContent(material));
        instance.addEntry(category, mineral.create());
    }

    private static void chemicalTreeEntry(ManualInstance instance, Tree.InnerNode<ResourceLocation, ManualEntry> category, MaterialInterface<?> material) {
        ManualEntry.ManualEntryBuilder mineral = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        mineral.setLocation(new ResourceLocation("immersivegeology", material.getName()));
        mineral.setContent(() -> IGContent.createMineralContent(material));
        instance.addEntry(category, mineral.create());
    }

    protected static ManualEntry.EntryData createMineralContent(MaterialInterface<?> material) {
        ArrayList<ManualEntry.SpecialElementData> itemList = new ArrayList<ManualEntry.SpecialElementData>();
        StringBuilder contentBuilder = new StringBuilder();
        IGContent.createRecipeChainPage(contentBuilder, itemList, material);
        String translatedTitle = I18n.m_118938_((String)("manual.immersivegeology." + material.getName()), (Object[])new Object[0]);
        String formattedContent = contentBuilder.toString().replaceAll("\r\n|\r|\n", "\n");
        return new ManualEntry.EntryData(translatedTitle, "", formattedContent, itemList);
    }

    private static void createRecipeChainPage(StringBuilder contentBuilder, ArrayList<ManualEntry.SpecialElementData> itemList, MaterialInterface<?> material) {
        List<IGRecipeChain> recipe_chain_data = ((GeologyMaterial)material.instance()).getRecipeChains().stream().sorted(Comparator.comparingInt(IGRecipeChain::getPriority)).toList();
        IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(material.getConfig());
        String process_info = Component.m_237110_((String)"manual.immersivegeology.generic.desc", (Object[])new Object[]{material.getTranslationName()}).getString();
        contentBuilder.append("<&item_display>").append(process_info);
        StringBuilder derivedString = new StringBuilder();
        List derivedMaterials = material.getDerivedMaterials().stream().toList();
        int size = material.getDerivedMaterials().size();
        for (int index = 0; index < size; ++index) {
            MaterialInterface derived = (MaterialInterface)derivedMaterials.get(index);
            derivedString.append(derived.getTranslationName());
            if (size <= 1) continue;
            if (index == size - 2) {
                derivedString.append(Component.m_237115_((String)"formatting.space").getString());
                derivedString.append(Component.m_237115_((String)"formatting.and").getString());
                derivedString.append(Component.m_237115_((String)"formatting.space").getString());
                continue;
            }
            if (index >= size - 1) continue;
            derivedString.append(", ");
        }
        contentBuilder.append("<&list>");
        if (!derivedString.isEmpty()) {
            String finalDerived = derivedString.toString();
            contentBuilder.append("<np>").append(Component.m_237110_((String)"manual.immersivegeology.generic.pre_chain_desc", (Object[])new Object[]{material.getTranslationName(), finalDerived}).getString());
        }
        itemList.add(new ManualEntry.SpecialElementData("list", 0, (SpecialManualElement)new ManualElementTable(ManualHelper.getManual(), IGContent.formatTable(IGContent.getOreConfigTable(config, material.getDefaultNoiseProbability()), ""), true)));
        for (int i = 0; i < recipe_chain_data.size(); ++i) {
            if (i == 0) {
                contentBuilder.append("<np>");
            }
            IGRecipeChain chain = recipe_chain_data.get(i);
            contentBuilder.append("<&").append(chain.getName()).append(">");
            if (i < recipe_chain_data.size() - 1) {
                contentBuilder.append("<np>");
            }
            itemList.add(new ManualEntry.SpecialElementData(chain.getName(), 0, (SpecialManualElement)new IGRecipeOverview(ManualHelper.getManual(), (GeologyMaterial)material.instance(), chain)));
        }
        NonNullList displayStacks = NonNullList.m_122779_();
        if (material.hasFlag(BlockCategoryFlags.ORE_BLOCK)) {
            for (StoneEnum stone : StoneEnum.values()) {
                IOreBlock ore;
                if (!((GeologyMaterial)material.instance()).acceptableStoneType(stone.instance()) || !stone.isVanilla() || (ore = material.getOreBlock(stone, OreRichness.NORMAL)) == null) continue;
                displayStacks.add((Object)new ItemStack((ItemLike)ore.asIGItem(), 1));
            }
        }
        itemList.add(new ManualEntry.SpecialElementData("item_display", 0, (SpecialManualElement)new ManualElementItem(ManualHelper.getManual(), displayStacks)));
    }

    public static HashMap<Component, Double> getOreConfigTable(IGServerConfig.Ores.OreConfig config, float noise_probability) {
        LinkedHashMap<Component, Double> map = new LinkedHashMap<Component, Double>();
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.can_spawn"), (Boolean)config.canSpawn.get() != false ? 1.0 : 0.0);
        double chunk_probability = (double)((Integer)config.generationChance.get()).intValue() / 2000000.0;
        double finalProb = (double)noise_probability * chunk_probability * 4096.0;
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.generation_probability"), finalProb);
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.min_y"), Double.valueOf(((Integer)config.minY.get()).intValue()));
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.max_y"), Double.valueOf(((Integer)config.maxY.get()).intValue()));
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.min_temp"), (Double)config.min_temp.get());
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.max_temp"), (Double)config.max_temp.get());
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.min_rainfall"), (Double)config.min_downfall.get());
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.max_rainfall"), (Double)config.max_downfall.get());
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.density"), (Double)config.density.get());
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.vein_size"), ((Integer)config.veinSize.get()).doubleValue());
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.generation_type"), Double.valueOf(((IGGenerationType)((Object)config.generationPattern.get())).ordinal()));
        return map;
    }

    static Component[][] formatTable(Map<Component, Double> map, String valueType) {
        ArrayList<Map.Entry<Component, Double>> sortedMapArray = new ArrayList<Map.Entry<Component, Double>>(map.entrySet());
        ArrayList<Component[]> list = new ArrayList<Component[]>();
        try {
            for (Map.Entry entry : sortedMapArray) {
                Component item = (Component)entry.getKey();
                if (item == null) {
                    item = Component.m_130674_((String)((Component)entry.getKey()).toString());
                }
                Object bt = String.valueOf(entry.getValue());
                if (item.toString().contains("manual.immersivegeology.generation_type")) {
                    int ordinal = ((Double)entry.getValue()).intValue();
                    bt = IGGenerationType.values()[ordinal].name();
                }
                if (item.toString().contains("can_spawn")) {
                    Object object = bt = ((Double)entry.getValue()).intValue() == 0 ? "False" : "True";
                }
                if (item.toString().contains("density") || item.toString().contains("generation_probability")) {
                    bt = new DecimalFormat("###.##").format((Double)entry.getValue() * 100.0) + "%";
                }
                Component am = Component.m_130674_((String)((String)bt + " " + valueType));
                list.add(new Component[]{item, am});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Component[][])list.toArray((T[])new Component[0][]);
    }

    static Component[][] formatBasicTable(Map<Component, String> map, String valueType) {
        ArrayList<Map.Entry<Component, String>> sortedMapArray = new ArrayList<Map.Entry<Component, String>>(map.entrySet());
        ArrayList<Component[]> list = new ArrayList<Component[]>();
        try {
            for (Map.Entry entry : sortedMapArray) {
                Component item = (Component)entry.getKey();
                if (item == null) {
                    item = Component.m_130674_((String)((Component)entry.getKey()).toString());
                }
                String bt = String.valueOf(entry.getValue());
                Component am = Component.m_130674_((String)(bt + " " + valueType));
                list.add(new Component[]{item, am});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Component[][])list.toArray((T[])new Component[0][]);
    }

    public static HashMap<Component, String> getEnergyRates() {
        LinkedHashMap<Component, String> map = new LinkedHashMap<Component, String>();
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.lv_heat"), "< 750");
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.mv_heat"), "< 3000");
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.hv_heat"), "< 12000");
        map.put((Component)Component.m_237115_((String)"manual.immersivegeology.ehv_heat"), "> 12000");
        return map;
    }

    private static void multiblockEntry(ManualInstance instance, Tree.InnerNode<ResourceLocation, ManualEntry> category, String id) {
        ManualEntry.ManualEntryBuilder multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        multiblock.readFromFile(new ResourceLocation("immersivegeology", id));
        instance.addEntry(category, multiblock.create());
    }

    private static void multiblockRotaryKilnEntry(ManualInstance instance, Tree.InnerNode<ResourceLocation, ManualEntry> category, String id) {
        ManualEntry.ManualEntryBuilder multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        multiblock.readFromFile(new ResourceLocation("immersivegeology", id));
        multiblock.addSpecialElement(new ManualEntry.SpecialElementData("list", 0, (SpecialManualElement)new ManualElementTable(instance, IGContent.formatBasicTable(IGContent.getEnergyRates(), "fe/t"), true)));
        instance.addEntry(category, multiblock.create());
    }
}

