/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology;

import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import com.igteam.immersivegeology.client.IGClientRenderHandler;
import com.igteam.immersivegeology.client.IGOverlayHandler;
import com.igteam.immersivegeology.client.menu.CreativeMenuHandler;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.block.multiblocks.IGTemplateMultiblock;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.event.IGCommonForgeEvents;
import com.igteam.immersivegeology.common.network.IGPacketHandler;
import com.igteam.immersivegeology.common.world.IGWorldSubscription;
import com.igteam.immersivegeology.core.ClientProxy;
import com.igteam.immersivegeology.core.CommonProxy;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.registration.IGContent;
import com.igteam.immersivegeology.core.registration.IGRecipeSerializers;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

@Mod(value="immersivegeology")
public class ImmersiveGeology {
    public static CommonProxy proxy = (CommonProxy)Util.m_137537_(() -> {
        if (FMLLoader.getDist().isClient()) {
            return new ClientProxy();
        }
        return new CommonProxy();
    });

    public ImmersiveGeology() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IGLib.IG_LOGGER.info("======== Starting Immersive Geology ========");
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::enqueueIMC);
        IGLib.IG_LOGGER.info("- Initializing IG Multiblocks");
        IGRegistrationHolder.initializeMultiblocks();
        IGLib.IG_LOGGER.info("- Recipe Serializer Registration");
        IGRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        IGLib.IG_LOGGER.info("- World Event Handler Registration");
        MinecraftForge.EVENT_BUS.register((Object)new IGWorldSubscription());
        IGLib.IG_LOGGER.info("- Client Configuration Registration");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)IGClientConfig.CONFIG_SPEC);
        IGLib.IG_LOGGER.info("- Server Configuration Registration");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)IGServerConfig.CONFIG_SPEC);
        IGRegistrationHolder.addRegistersToEventBus(modEventBus);
        IGLib.IG_LOGGER.info("- Network Packet Handler Registration");
        IGPacketHandler.initialize();
        proxy.modConstruction();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        IGLib.IG_LOGGER.info("- Custom Creative Menu Registration");
        MinecraftForge.EVENT_BUS.register((Object)new CreativeMenuHandler());
        IGLib.IG_LOGGER.info("- Custom Multiblock Overlay Registration");
        MinecraftForge.EVENT_BUS.register((Object)new IGOverlayHandler());
        IGLib.IG_LOGGER.info("- Client Render Handler Registration");
        IGClientRenderHandler.register();
        IGClientRenderHandler.init(event);
        IGLib.IG_LOGGER.info("- Color Tint Registration");
        this.supplyMaterialTint();
        IGLib.IG_LOGGER.info("- Container And Screen Registration");
        IGContent.registerContainersAndScreens();
        IGLib.IG_LOGGER.info("- Custom IE Manual Entry Registration");
        IGContent.initializeManualEntries();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        for (TemplateMultiblock template : IGRegistrationHolder.MB_TEMPLATE_MAP.values()) {
            if (!(template instanceof IGTemplateMultiblock)) continue;
            IGTemplateMultiblock ig = (IGTemplateMultiblock)template;
            ResourceLocation id = ig.getUniqueName();
            ItemStack formation = ig.getFormationItem();
            InterModComms.sendTo((String)"engineered_schematics", (String)"formation_item", () -> Pair.of((Object)id, (Object)formation));
        }
    }

    private void supplyMaterialTint() {
        Minecraft minecraft = Minecraft.m_91087_();
        BiPredicate<GeologyMaterial, IFlagType> needsColorCheck = (material, flagType) -> material.getFlags().contains(flagType);
        BiFunction<IFlagType, GeologyMaterial, Boolean> resourceExists = (flagType, material) -> {
            ResourceLocation testLocation = ImmersiveGeology.getResourceLocationTest(flagType, material);
            try {
                return minecraft.m_91098_().m_213713_(testLocation).isPresent();
            }
            catch (Exception e) {
                return false;
            }
        };
        for (MaterialInterface materialInterface : IGLib.getGeologyMaterials()) {
            Object base = materialInterface.instance();
            HashMap colorCheckMap = new HashMap();
            for (IFlagType<?> flagType2 : IFlagType.getAllRegistryFlags()) {
                if (needsColorCheck.test((GeologyMaterial)base, flagType2)) {
                    colorCheckMap.put(flagType2, resourceExists.apply(flagType2, (GeologyMaterial)base) == false);
                    continue;
                }
                colorCheckMap.put(flagType2, true);
            }
            BiPredicate<IFlagType<?>, Integer> colorTintPredicate = (flagType, tintIndex) -> colorCheckMap.getOrDefault(flagType, true);
            ((GeologyMaterial)base).initializeColorTint(colorTintPredicate);
        }
    }

    @NotNull
    private static ResourceLocation getResourceLocationTest(IFlagType<?> pattern, GeologyMaterial base) {
        ResourceLocation test = new ResourceLocation("immersivegeology", "textures/" + (pattern instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + base.getName() + "/" + pattern.getName() + ".png");
        if (pattern.equals(BlockCategoryFlags.STAIRS)) {
            test = new ResourceLocation("immersivegeology", "textures/" + (pattern instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + base.getName() + "/" + BlockCategoryFlags.STORAGE_BLOCK.getName() + ".png");
        }
        if (pattern.equals(BlockCategoryFlags.FENCE)) {
            test = new ResourceLocation("immersivegeology", "textures/" + (pattern instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + base.getName() + "/" + BlockCategoryFlags.STORAGE_BLOCK.getName() + ".png");
        }
        if (pattern.equals(BlockCategoryFlags.SLAB)) {
            test = new ResourceLocation("immersivegeology", "textures/" + (pattern instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + base.getName() + "/" + BlockCategoryFlags.STORAGE_BLOCK.getName() + ".png");
        }
        if (pattern.equals(BlockCategoryFlags.SHEETMETAL_SLAB)) {
            test = new ResourceLocation("immersivegeology", "textures/" + (pattern instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + base.getName() + "/" + BlockCategoryFlags.SHEETMETAL_BLOCK.getName() + ".png");
        }
        if (pattern.equals(BlockCategoryFlags.SHEETMETAL_STAIRS)) {
            test = new ResourceLocation("immersivegeology", "textures/" + (pattern instanceof ItemCategoryFlags ? "item" : "block") + "/colored/" + base.getName() + "/" + BlockCategoryFlags.SHEETMETAL_BLOCK.getName() + ".png");
        }
        if (pattern.equals(ItemCategoryFlags.NORMAL_ORE) || pattern.equals(ItemCategoryFlags.RICH_ORE) || pattern.equals(ItemCategoryFlags.POOR_ORE)) {
            OreRichness richness = pattern.equals(ItemCategoryFlags.NORMAL_ORE) ? OreRichness.NORMAL : (pattern.equals(ItemCategoryFlags.RICH_ORE) ? OreRichness.RICH : OreRichness.POOR);
            test = new ResourceLocation("immersivegeology", "textures/item/colored/raw_ore/" + base.getName().toLowerCase() + "/" + richness.getSanitizedName() + ".png");
        }
        return test;
    }

    public void setup(FMLCommonSetupEvent event) {
        IGRegistrationHolder.buildMaterialRecipes();
        IGLib.IG_LOGGER.info("- Event Handler Registration");
        MinecraftForge.EVENT_BUS.register((Object)new IGCommonForgeEvents());
        proxy.registerFluidBehaviour(event);
    }
}

