/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client;

import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.common.fluid.IGFluidBlock;
import com.igteam.immersivegeology.common.item.IGGenericBlockItem;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class IGClientRenderHandler
implements ItemColor,
BlockColor {
    @OnlyIn(value=Dist.CLIENT)
    private static Map<RenderTypeSkeleton, RenderType> renderTypes;
    private static final Map<Block, RenderTypeSkeleton> mapping;
    private static final Map<Block, Block> inheritances;
    public static IGClientRenderHandler INSTANCE;

    public static void register() {
        for (Supplier supplier : IGRegistrationHolder.getItemRegistryMap().values()) {
            Item i = (Item)supplier.get();
            if (!(i instanceof IGFlagItem)) continue;
            Minecraft.m_91087_().getItemColors().m_92689_((ItemColor)INSTANCE, new ItemLike[]{i});
        }
        for (RegistryObject<Item> registryObject : IGRegistrationHolder.getBlockRegistryMap().values()) {
            Block b = (Block)registryObject.get();
            if (b instanceof IGBlockType) {
                IGBlockType igBlock = (IGBlockType)b;
                Minecraft.m_91087_().m_91298_().m_92589_((BlockColor)INSTANCE, new Block[]{b});
                IGClientRenderHandler.setRenderType(b, igBlock.getFlag().getRenderType());
            }
            if (!(b instanceof IGFluidBlock)) continue;
            IGFluidBlock fluidBlock = (IGFluidBlock)b;
            if (fluidBlock.isTranslucent()) {
                ItemBlockRenderTypes.setRenderLayer((Fluid)fluidBlock.getFluid().m_5613_(), (RenderType)RenderType.m_110466_());
                ItemBlockRenderTypes.setRenderLayer((Fluid)fluidBlock.getFluid().m_5615_(), (RenderType)RenderType.m_110466_());
                continue;
            }
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluidBlock.getFluid().m_5613_(), (RenderType)RenderType.m_110451_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluidBlock.getFluid().m_5615_(), (RenderType)RenderType.m_110451_());
        }
        IGClientRenderHandler.setRenderType((Block)IGMultiblockProvider.COREDRILL.block().get(), RenderTypeSkeleton.CUTOUT_MIPPED);
        IGClientRenderHandler.setRenderType((Block)IGMultiblockProvider.CHEMICAL_REACTOR.block().get(), RenderTypeSkeleton.CUTOUT_MIPPED);
        IGClientRenderHandler.setRenderType((Block)IGMultiblockProvider.REVERBERATION_FURNACE.block().get(), RenderTypeSkeleton.CUTOUT_MIPPED);
        IGClientRenderHandler.setRenderType((Block)IGMultiblockProvider.BLOOMERY.block().get(), RenderTypeSkeleton.CUTOUT_MIPPED);
        IGClientRenderHandler.setRenderType((Block)IGMultiblockProvider.GRAVITY_SEPARATOR.block().get(), RenderTypeSkeleton.CUTOUT_MIPPED);
        IGClientRenderHandler.setRenderType((Block)IGMultiblockProvider.ROTARYKILN.block().get(), RenderTypeSkeleton.CUTOUT_MIPPED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init(FMLClientSetupEvent event) {
        for (Block b : inheritances.keySet()) {
            Block inherit = inheritances.get(b);
            if (!mapping.containsKey(inherit)) continue;
            mapping.put(b, mapping.get(inherit));
        }
        for (Block b : mapping.keySet()) {
            ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)renderTypes.get((Object)mapping.get(b)));
        }
        inheritances.clear();
        mapping.clear();
    }

    public int m_92566_(BlockState state, @Nullable BlockAndTintGetter getter, @Nullable BlockPos pos, int index) {
        Block block = state.m_60734_();
        if (block instanceof IGBlockType) {
            IGBlockType type = (IGBlockType)block;
            if (type.getFlag().equals(BlockCategoryFlags.ORE_BLOCK)) {
                return 0xFFFFFF;
            }
            return type.getColor(index, state);
        }
        return 0xFFFFFF;
    }

    public int m_92671_(ItemStack stack, int tintIndex) {
        Item item = stack.m_41720_();
        if (item instanceof IGFlagItem) {
            IGGenericBlockItem b;
            IGFlagItem type = (IGFlagItem)item;
            Item item2 = stack.m_41720_();
            if (item2 instanceof IGGenericBlockItem && (b = (IGGenericBlockItem)item2).getFlag().equals(BlockCategoryFlags.ORE_BLOCK)) {
                return 0xFFFFFF;
            }
            return type.getColor(tintIndex);
        }
        return 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderType(Block block, RenderTypeSkeleton skeleton) {
        IGClientRenderHandler.setRenderTypeClient(block, skeleton);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setRenderTypeClient(Block block, RenderTypeSkeleton skeleton) {
        IGClientRenderHandler.resolveRenderTypes();
        mapping.put(block, skeleton);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void resolveRenderTypes() {
        if (renderTypes == null) {
            renderTypes = new HashMap<RenderTypeSkeleton, RenderType>();
            renderTypes.put(RenderTypeSkeleton.SOLID, RenderType.m_110451_());
            renderTypes.put(RenderTypeSkeleton.CUTOUT, RenderType.m_110463_());
            renderTypes.put(RenderTypeSkeleton.CUTOUT_MIPPED, RenderType.m_110457_());
            renderTypes.put(RenderTypeSkeleton.TRANSLUCENT, RenderType.m_110466_());
        }
    }

    static {
        mapping = new HashMap<Block, RenderTypeSkeleton>();
        inheritances = new HashMap<Block, Block>();
        INSTANCE = new IGClientRenderHandler();
    }

    public static enum RenderTypeSkeleton {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

