/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.helper;

import com.igteam.immersivegeology.client.helper.FluidCuboid;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class IGFluidRenderHelper {
    public static void putTexturedQuad(VertexConsumer renderer, Matrix4f matrix, Matrix3f normalMatrix, TextureAtlasSprite sprite, Vector3f from, Vector3f to, Direction face, int color, int brightness, int rotation, boolean flowing) {
        float u4;
        float v3;
        float u3;
        float maxV;
        float minV;
        float maxU;
        float minU;
        double size;
        float temp;
        float v1;
        float u2;
        float u1;
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        float v2 = switch (face) {
            default -> {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                yield z1;
            }
            case Direction.UP -> {
                u1 = x1;
                u2 = x2;
                v1 = -z1;
                yield -z2;
            }
            case Direction.NORTH -> {
                u1 = -x1;
                u2 = -x2;
                v1 = y1;
                yield y2;
            }
            case Direction.SOUTH -> {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                yield y2;
            }
            case Direction.WEST -> {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                yield y2;
            }
            case Direction.EAST -> {
                u1 = -z1;
                u2 = -z2;
                v1 = y1;
                yield y2;
            }
        };
        if (rotation == 0 || rotation == 270) {
            temp = v1;
            v1 = -v2;
            v2 = -temp;
        }
        if (rotation >= 180) {
            temp = u1;
            u1 = -u2;
            u2 = -temp;
        }
        boolean reverse = u1 > u2;
        u1 = IGFluidRenderHelper.boundUV(u1, reverse);
        u2 = IGFluidRenderHelper.boundUV(u2, !reverse);
        reverse = v1 > v2;
        v1 = IGFluidRenderHelper.boundUV(v1, reverse);
        v2 = IGFluidRenderHelper.boundUV(v2, !reverse);
        double d = size = flowing ? 8.0 : 16.0;
        if (rotation % 180 == 90) {
            minU = sprite.m_118367_((double)v1 * size);
            maxU = sprite.m_118367_((double)v2 * size);
            minV = sprite.m_118393_((double)u1 * size);
            maxV = sprite.m_118393_((double)u2 * size);
        } else {
            minU = sprite.m_118367_((double)u1 * size);
            maxU = sprite.m_118367_((double)u2 * size);
            minV = sprite.m_118393_((double)v1 * size);
            maxV = sprite.m_118393_((double)v2 * size);
        }
        float v4 = switch (rotation) {
            default -> {
                u1 = minU;
                v1 = maxV;
                u2 = minU;
                v2 = minV;
                u3 = maxU;
                v3 = minV;
                u4 = maxU;
                yield maxV;
            }
            case 90 -> {
                u1 = minU;
                v1 = minV;
                u2 = maxU;
                v2 = minV;
                u3 = maxU;
                v3 = maxV;
                u4 = minU;
                yield maxV;
            }
            case 180 -> {
                u1 = maxU;
                v1 = minV;
                u2 = maxU;
                v2 = maxV;
                u3 = minU;
                v3 = maxV;
                u4 = minU;
                yield minV;
            }
            case 270 -> {
                u1 = maxU;
                v1 = maxV;
                u2 = minU;
                v2 = maxV;
                u3 = minU;
                v3 = minV;
                u4 = maxU;
                yield minV;
            }
        };
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (face) {
            case DOWN: {
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                break;
            }
            case UP: {
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                break;
            }
            case NORTH: {
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                break;
            }
            case SOUTH: {
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                break;
            }
            case WEST: {
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                break;
            }
            case EAST: {
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_5752_();
            }
        }
    }

    public static void renderCuboid(PoseStack matrices, VertexConsumer buffer, FluidCuboid cube, TextureAtlasSprite still, TextureAtlasSprite flowing, Vector3f from, Vector3f to, int color, int light) {
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        Matrix3f normal = matrices.m_85850_().m_252943_();
        for (Direction dir : Direction.values()) {
            FluidCuboid.FluidFace face = cube.getFace(dir);
            if (face == null) continue;
            boolean isFlowing = face.isFlowing();
            int faceRot = face.rotation() % 360;
            IGFluidRenderHelper.putTexturedQuad(buffer, matrix, normal, isFlowing ? flowing : still, from, to, dir, color, light, faceRot, isFlowing);
        }
    }

    private static float boundUV(float value, boolean upper) {
        if ((value %= 1.0f) == 0.0f) {
            return upper ? 1.0f : 0.0f;
        }
        return value < 0.0f ? value + 1.0f : value;
    }
}

