/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGGraphLayoutManager;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

public class IGRecipeOverview
extends SpecialManualElements {
    private final GeologyMaterial material;
    private IGRecipeNode selectedNode = null;
    private boolean setChainPositions = false;
    private final IGRecipeChain chain_to_display;
    private static final ResourceLocation TEXTURE_ARROWS = IGLib.makeTextureLocation("manual/arrows");
    private final HashSet<IGRecipeNode> rendered_nodes = new HashSet();
    IGGraphLayoutManager manager = new IGGraphLayoutManager();
    private final int NODE_SIZE = 16;

    public IGRecipeOverview(ManualInstance manual, GeologyMaterial material, IGRecipeChain chain_to_display) {
        super(manual);
        this.material = material;
        this.chain_to_display = chain_to_display;
    }

    public IGRecipeOverview(ManualInstance manual, GeologyMaterial material, int priority) {
        super(manual);
        this.material = material;
        this.chain_to_display = material.getRecipeChains().stream().filter(c -> c.getPriority() == priority).findFirst().get();
    }

    public int getPixelsTaken() {
        return 100;
    }

    private void drawCenteredStringScaled(GuiGraphics graphics, Font fr, String s, int x, int y, int colour, boolean shadow) {
        int xx = (int)Math.floor((double)x - (double)fr.m_92895_(s) / 2.0);
        double var10000 = y;
        Objects.requireNonNull(fr);
        int yy = (int)Math.floor(var10000 - 4.5);
        graphics.m_280056_(fr, s, xx, yy, colour, shadow);
    }

    private void drawHackySubtext(GuiGraphics graphics, ManualScreen screen) {
        String subtext = I18n.m_118938_((String)("manual.immersivegeology." + this.chain_to_display.getName() + ".subtext"), (Object[])new Object[0]);
        this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), this.manual.formatEntrySubtext(subtext), screen.getManual().pageWidth / 2, -6, this.manual.getSubTitleColour(), true);
    }

    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        if (this.chain_to_display != null) {
            this.rendered_nodes.clear();
            IGRecipeChain chain = this.chain_to_display;
            List<IGRecipeNode> roots = chain.getRootNodes();
            this.drawHackySubtext(graphics, screen);
            if (!roots.isEmpty()) {
                if (!this.setChainPositions) {
                    this.manager.layoutChain(chain);
                    this.setChainPositions = true;
                }
                int baseX = x;
                int baseY = y;
                graphics.m_280168_().m_85836_();
                if (this.selectedNode == null) {
                    for (IGRecipeNode root : roots) {
                        this.renderChain(graphics, screen, root, baseX, baseY, mx, my, 0x66666666, this.rendered_nodes);
                    }
                    for (IGRecipeNode root : roots) {
                        root.resetRender();
                    }
                }
                graphics.m_280168_().m_85849_();
                if (this.selectedNode != null) {
                    IGRecipeMethod method = this.selectedNode.getMethod();
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, 999.0f);
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_((float)screen.getManual().pageWidth / 2.0f - 16.0f, (float)screen.getManual().pageHeight - (float)screen.getManual().pageHeight / 4.0f, 0.0f);
                    graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
                    graphics.m_280064_(method.getIconStack(), x, y, mx, my);
                    graphics.m_280168_().m_85849_();
                    int renderX = screen.getManual().pageWidth / 2 - 50;
                    int renderY = 0;
                    ManualUtils.drawTexturedRect((GuiGraphics)graphics, (ResourceLocation)method.getMethod().getGuiLocation(), (int)renderX, (int)renderY, (int)101, (int)101, (float[])new float[]{0.0f, 1.0f, 0.0f, 1.0f});
                    method.render(graphics, screen, renderX, renderY, mx, my);
                    graphics.m_280168_().m_85849_();
                    if (mx > -8 && mx < 8 && my > -20 && my < -4) {
                        if (GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) == 1) {
                            this.selectedNode = null;
                        }
                        graphics.m_280246_(0.75f, 0.75f, 0.75f, 1.0f);
                    }
                    graphics.m_280480_(new ItemStack((ItemLike)Items.f_42127_), -8, -20);
                    graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    private void renderChain(GuiGraphics graphics, ManualScreen screen, IGRecipeNode node, int baseX, int baseY, int mx, int my, int color, Set<IGRecipeNode> visited) {
        if (!visited.add(node)) {
            return;
        }
        int nodeX = baseX + node.getX() * 32;
        int nodeY = baseY + node.getY() * 32;
        IGRecipeMethod method = node.getMethod();
        if (mx > nodeX && nodeX + 16 > mx && my > nodeY && nodeY + 16 > my && GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) == 1) {
            this.selectedNode = node;
        }
        method.renderMB(graphics, method.getIconStack(), nodeX, nodeY, mx, my);
        for (IGRecipeNode child : node.getChildren()) {
            this.drawConnectionLine(graphics, baseX, baseY, node, child, color);
            if (!child.shouldRender) continue;
            this.renderChain(graphics, screen, child, baseX, baseY, mx, my, color, visited);
            child.shouldRender = false;
        }
    }

    private void drawConnectionLine(GuiGraphics graphics, int baseX, int baseY, IGRecipeNode from, IGRecipeNode to, int color) {
        int x1 = baseX + (from.getX() + 256);
        int y1 = baseY + (from.getY() + 256);
        int x2 = baseX + (to.getX() + 256);
        int y2 = baseY + (to.getY() + 256);
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        float angle = (float)Math.atan2(deltaY, deltaX);
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY) * 32.0;
        this.drawDirectLine(graphics, baseX + from.getX() * 32 + 8, baseY + from.getY() * 32 + 8, angle, (int)distance, color);
    }

    private void drawDirectLine(GuiGraphics graphics, int x1, int y1, float angle, int length, int color) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x1, (float)y1, 0.0f);
        pose.m_85836_();
        pose.m_252781_(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        graphics.m_280509_(0, -1, length, 1, color);
        pose.m_85849_();
        pose.m_85849_();
    }

    public boolean listForSearch(String s) {
        return false;
    }
}

