/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.menu;

import com.igteam.immersivegeology.client.menu.IGItemGroup;
import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class CreativeMenuHandler {
    private static final ResourceLocation CEX_GUI_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/creative_expansion.png");
    private static ArrayList<CreativeMenuButton> subGroupButtons = new ArrayList();
    boolean reset = true;
    Logger logger = IGLib.getNewLogger();
    boolean jeiCompatUpdate = false;

    @SubscribeEvent
    public void drawScreen(ScreenEvent.BackgroundRendered event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen gui = (CreativeModeInventoryScreen)screen;
            int i = (int)((double)gui.getGuiLeft() - Math.floor(193.8));
            CreativeModeTab selectedTab = CreativeModeInventoryScreen.f_98507_;
            CreativeModeTab igTab = (CreativeModeTab)IGRegistrationHolder.IG_BASE_TAB.get();
            if (selectedTab.equals(igTab)) {
                if (this.reset) {
                    screen.m_6574_(event.getScreen().getMinecraft(), screen.f_96543_, screen.f_96544_);
                }
                if (!this.jeiCompatUpdate) {
                    IGItemGroup.updateSubGroup(ItemSubGroup.geologic);
                    this.jeiCompatUpdate = true;
                }
                if (!subGroupButtons.isEmpty()) {
                    subGroupButtons.forEach(button -> {
                        button.f_93623_ = true;
                        button.f_93624_ = true;
                    });
                }
                PoseStack matrixStack = event.getGuiGraphics().m_280168_();
                matrixStack.m_85836_();
                GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiGraphics pgui = event.getGuiGraphics();
                matrixStack.m_85849_();
            } else {
                this.reset = true;
                if (!subGroupButtons.isEmpty()) {
                    subGroupButtons.forEach(button -> {
                        button.f_93623_ = false;
                        button.f_93624_ = false;
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public void initializeGuiEvent(ScreenEvent.Init.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen gui = (CreativeModeInventoryScreen)screen;
            int i = (int)((double)gui.getGuiLeft() - Math.floor(193.8));
            int j = (gui.f_96544_ - 195) / 2;
            ItemSubGroup[] groups = ItemSubGroup.values();
            for (int iteration = 0; iteration < ItemSubGroup.values().length; ++iteration) {
                ItemSubGroup currentGroup = groups[iteration];
                CreativeMenuButton button = new CreativeMenuButton(gui, currentGroup, i + 166, j + 32 + 27 * iteration, button1 -> {
                    IGItemGroup.updateSubGroup(currentGroup);
                    gui.m_6574_(gui.getMinecraft(), gui.f_96543_, gui.f_96544_);
                }, narration -> Component.m_237115_((String)""));
                subGroupButtons.add(button);
                event.addListener((GuiEventListener)button);
            }
        }
    }

    public static class CreativeMenuButton
    extends Button {
        public CreativeModeInventoryScreen screen;
        public CreativeModeInventoryScreen.ItemPickerMenu contained;
        public ItemSubGroup group;

        public CreativeMenuButton(CreativeModeInventoryScreen screen, ItemSubGroup group, int x, int y, Button.OnPress onPress, Button.CreateNarration narration) {
            super(28, 24, x, y, (Component)Component.m_237115_((String)""), onPress, narration);
            this.f_93618_ = 28;
            this.f_93619_ = 24;
            this.m_252865_(x);
            this.m_253211_(y);
            this.contained = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
            this.screen = screen;
            this.group = group;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            ItemStack stack;
            MaterialInterface<?> materialInterface;
            if (!this.f_93624_) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int x = this.m_252754_();
            int y = this.m_252907_();
            int normalX = 0;
            int normalY = 0;
            boolean hovered = pMouseX >= x && pMouseY >= y && pMouseX < x + this.f_93618_ && pMouseY < y + this.f_93619_;
            boolean isSelected = IGItemGroup.getCurrentSubGroup().equals((Object)this.group);
            int variant = isSelected ? 0 : (hovered ? 1 : 2);
            pGuiGraphics.m_280218_(CEX_GUI_TEXTURES, x, y, normalX + this.f_93618_ * variant, normalY + this.f_93619_ * this.group.ordinal(), this.f_93618_, this.f_93619_);
            IFlagType<?> groupPattern = this.group.getFlag();
            if (groupPattern.equals(ItemCategoryFlags.BUCKET) && (materialInterface = this.group.getMaterial()) instanceof ChemicalEnum) {
                ChemicalEnum chemical_base = (ChemicalEnum)materialInterface;
                stack = this.group.getSecondary().equals(this.group.getMaterial()) ? new ItemStack((ItemLike)chemical_base.getFluid(BlockCategoryFlags.FLUID).m_6859_().m_5456_()) : new ItemStack((ItemLike)chemical_base.getSlurryWith(this.group.getSecondary()).m_6859_().m_5456_());
            } else {
                stack = this.group.getMaterial().getStack(groupPattern);
            }
            int offset = 3;
            if (isSelected) {
                pGuiGraphics.m_280480_(stack, x + 7, y + offset);
            } else if (hovered) {
                pGuiGraphics.m_280480_(stack, x + 6, y + offset);
            } else {
                pGuiGraphics.m_280480_(stack, x + 6, y + offset);
            }
            if (hovered) {
                String name = this.group.name();
                String name_part = name.substring(0, 1).toUpperCase();
                String corrected_name = name_part + name.substring(1);
                pGuiGraphics.m_280557_(mc.f_91062_, (Component)Component.m_237115_((String)corrected_name), pMouseX, pMouseY);
            }
        }
    }
}

